/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.stats;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.Row;
import io.delta.kernel.internal.data.GenericRow;
import io.delta.kernel.internal.util.InternalUtils;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.metrics.FileSizeHistogramResult;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.StructType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class FileSizeHistogram {
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;
    public static final StructType FULL_SCHEMA = new StructType().add("sortedBinBoundaries", new ArrayType(LongType.LONG, false)).add("fileCounts", new ArrayType(LongType.LONG, false)).add("totalBytes", new ArrayType(LongType.LONG, false));
    private final long[] sortedBinBoundaries;
    private final long[] fileCounts;
    private final long[] totalBytes;

    public static FileSizeHistogram createDefaultHistogram() {
        long[] lArray = FileSizeHistogram.createDefaultBinBoundaries();
        long[] lArray2 = new long[lArray.length];
        long[] lArray3 = new long[lArray.length];
        return new FileSizeHistogram(lArray, lArray2, lArray3);
    }

    public static Optional<FileSizeHistogram> fromColumnVector(ColumnVector columnVector, int n) {
        if (columnVector.isNullAt(n)) {
            return Optional.empty();
        }
        int n2 = FULL_SCHEMA.indexOf("sortedBinBoundaries");
        int n3 = FULL_SCHEMA.indexOf("totalBytes");
        int n4 = FULL_SCHEMA.indexOf("fileCounts");
        List list = VectorUtils.toJavaList(InternalUtils.requireNonNull(columnVector.getChild(n2), n, "sortedBinBoundaries").getArray(n));
        List list2 = VectorUtils.toJavaList(InternalUtils.requireNonNull(columnVector.getChild(n3), n, "totalBytes").getArray(n));
        List list3 = VectorUtils.toJavaList(InternalUtils.requireNonNull(columnVector.getChild(n4), n, "fileCounts").getArray(n));
        long[] lArray = list.stream().mapToLong(Long::longValue).toArray();
        long[] lArray2 = list2.stream().mapToLong(Long::longValue).toArray();
        long[] lArray3 = list3.stream().mapToLong(Long::longValue).toArray();
        return Optional.of(new FileSizeHistogram(lArray, lArray3, lArray2));
    }

    private static long[] createDefaultBinBoundaries() {
        long l;
        int n = 95;
        long[] lArray = new long[n];
        int n2 = 0;
        lArray[n2++] = 0L;
        for (l = 8192L; l <= 0x400000L; l *= 2L) {
            lArray[n2++] = l;
        }
        for (l = 0x800000L; l <= 0x2800000L; l += 0x400000L) {
            lArray[n2++] = l;
        }
        for (l = 0x3000000L; l <= 0x7800000L; l += 0x800000L) {
            lArray[n2++] = l;
        }
        for (l = 0x7C00000L; l <= 0x9000000L; l += 0x400000L) {
            lArray[n2++] = l;
        }
        for (l = 0xA000000L; l <= 0x24000000L; l += 0x1000000L) {
            lArray[n2++] = l;
        }
        for (l = 0x28000000L; l <= 0x58000000L; l += 0x4000000L) {
            lArray[n2++] = l;
        }
        for (l = 0x60000000L; l <= 0x80000000L; l += 0x8000000L) {
            lArray[n2++] = l;
        }
        for (l = 0x90000000L; l <= 0x100000000L; l += 0x10000000L) {
            lArray[n2++] = l;
        }
        for (l = 0x200000000L; l <= 0x4000000000L; l *= 2L) {
            lArray[n2++] = l;
        }
        Preconditions.checkArgument(n2 == n, "Incorrect pre-calculated size. Expected %s but got %s", n, n2);
        return lArray;
    }

    public static FileSizeHistogram fromFileSizeHistogramResult(FileSizeHistogramResult fileSizeHistogramResult) {
        Objects.requireNonNull(fileSizeHistogramResult);
        return new FileSizeHistogram(fileSizeHistogramResult.getSortedBinBoundaries(), fileSizeHistogramResult.getFileCounts(), fileSizeHistogramResult.getTotalBytes());
    }

    private FileSizeHistogram(long[] lArray, long[] lArray2, long[] lArray3) {
        Objects.requireNonNull(lArray, "sortedBinBoundaries cannot be null");
        Objects.requireNonNull(lArray2, "fileCounts cannot be null");
        Objects.requireNonNull(lArray3, "totalBytes cannot be null");
        Preconditions.checkArgument(lArray.length >= 2, "sortedBinBoundaries must have at least 2 elements to define a range");
        Preconditions.checkArgument(lArray[0] == 0L, "First boundary must be 0, got %s", lArray[0]);
        Preconditions.checkArgument(lArray.length == lArray2.length && lArray.length == lArray3.length, "All arrays must have the same length");
        this.sortedBinBoundaries = lArray;
        this.fileCounts = lArray2;
        this.totalBytes = lArray3;
    }

    public void insert(long l) {
        Preconditions.checkArgument(l >= 0L, "File size must be non-negative, got %s", l);
        int n = this.getBinIndex(l);
        Preconditions.checkArgument(n >= 0, "getBinIndex must return non-negative index for non-negative fileSize, got %s", n);
        int n2 = n;
        this.fileCounts[n2] = this.fileCounts[n2] + 1L;
        int n3 = n;
        this.totalBytes[n3] = this.totalBytes[n3] + l;
    }

    public void remove(long l) {
        Preconditions.checkArgument(l >= 0L, "File size must be non-negative, got %s", l);
        int n = this.getBinIndex(l);
        Preconditions.checkArgument(n >= 0, "getBinIndex must return non-negative index for non-negative fileSize, got %s", n);
        Preconditions.checkArgument(this.totalBytes[n] >= l && this.fileCounts[n] > 0L, "Cannot remove %s bytes from bin %d which only has %s bytes or does not have any files", l, n, this.totalBytes[n]);
        int n2 = n;
        this.fileCounts[n2] = this.fileCounts[n2] - 1L;
        int n3 = n;
        this.totalBytes[n3] = this.totalBytes[n3] - l;
    }

    private int getBinIndex(long l) {
        int n = Arrays.binarySearch(this.sortedBinBoundaries, l);
        return n >= 0 ? n : -(n + 1) - 1;
    }

    public Row toRow() {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(FULL_SCHEMA.indexOf("sortedBinBoundaries"), VectorUtils.buildArrayValue(Arrays.stream(this.sortedBinBoundaries).boxed().collect(Collectors.toList()), LongType.LONG));
        hashMap.put(FULL_SCHEMA.indexOf("fileCounts"), VectorUtils.buildArrayValue(Arrays.stream(this.fileCounts).boxed().collect(Collectors.toList()), LongType.LONG));
        hashMap.put(FULL_SCHEMA.indexOf("totalBytes"), VectorUtils.buildArrayValue(Arrays.stream(this.totalBytes).boxed().collect(Collectors.toList()), LongType.LONG));
        return new GenericRow(FULL_SCHEMA, hashMap);
    }

    public FileSizeHistogramResult captureFileSizeHistogramResult() {
        return new FileSizeHistogramResult(){
            final long[] copiedSortedBinBoundaries;
            final long[] copiedFileCounts;
            final long[] copiedTotalBytes;
            {
                this.copiedSortedBinBoundaries = Arrays.copyOf(FileSizeHistogram.this.sortedBinBoundaries, FileSizeHistogram.this.sortedBinBoundaries.length);
                this.copiedFileCounts = Arrays.copyOf(FileSizeHistogram.this.fileCounts, FileSizeHistogram.this.fileCounts.length);
                this.copiedTotalBytes = Arrays.copyOf(FileSizeHistogram.this.totalBytes, FileSizeHistogram.this.totalBytes.length);
            }

            @Override
            public long[] getSortedBinBoundaries() {
                return this.copiedSortedBinBoundaries;
            }

            @Override
            public long[] getFileCounts() {
                return this.copiedFileCounts;
            }

            @Override
            public long[] getTotalBytes() {
                return this.copiedTotalBytes;
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FileSizeHistogram fileSizeHistogram = (FileSizeHistogram)object;
        return Arrays.equals(this.sortedBinBoundaries, fileSizeHistogram.sortedBinBoundaries) && Arrays.equals(this.fileCounts, fileSizeHistogram.fileCounts) && Arrays.equals(this.totalBytes, fileSizeHistogram.totalBytes);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.sortedBinBoundaries), Arrays.hashCode(this.fileCounts), Arrays.hashCode(this.totalBytes));
    }
}

