/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.tablefeatures;

import io.delta.kernel.exceptions.KernelException;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.TableConfig;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.tablefeatures.FeatureAutoEnabledByMetadata;
import io.delta.kernel.internal.tablefeatures.TableFeature;
import io.delta.kernel.internal.util.CaseInsensitiveMap;
import io.delta.kernel.internal.util.ColumnMapping;
import io.delta.kernel.internal.util.SchemaUtils;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.FieldMetadata;
import io.delta.kernel.types.StructType;
import io.delta.kernel.types.TimestampNTZType;
import io.delta.kernel.types.VariantType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TableFeatures {
    public static String SET_TABLE_FEATURE_SUPPORTED_PREFIX = "delta.feature.";
    public static final TableFeature APPEND_ONLY_W_FEATURE = new AppendOnlyFeature();
    public static final TableFeature INVARIANTS_W_FEATURE = new InvariantsFeature();
    public static final TableFeature CONSTRAINTS_W_FEATURE = new ConstraintsFeature();
    public static final TableFeature CHANGE_DATA_FEED_W_FEATURE = new ChangeDataFeedFeature();
    public static final TableFeature COLUMN_MAPPING_RW_FEATURE = new ColumnMappingFeature();
    public static final TableFeature GENERATED_COLUMNS_W_FEATURE = new GeneratedColumnsFeature();
    public static final TableFeature IDENTITY_COLUMNS_W_FEATURE = new IdentityColumnsFeature();
    public static final TableFeature VARIANT_RW_FEATURE = new VariantTypeTableFeature();
    public static final TableFeature VARIANT_RW_PREVIEW_FEATURE = new VariantTypeTableFeatureBase("variantType-preview");
    public static final TableFeature VARIANT_SHREDDING_PREVIEW_RW_FEATURE = new VariantShreddingPreviewFeature();
    public static final TableFeature DOMAIN_METADATA_W_FEATURE = new DomainMetadataFeature();
    public static final TableFeature CLUSTERING_W_FEATURE = new ClusteringTableFeature();
    public static final TableFeature ROW_TRACKING_W_FEATURE = new RowTrackingFeature();
    public static final TableFeature DELETION_VECTORS_RW_FEATURE = new DeletionVectorsTableFeature();
    public static final TableFeature ICEBERG_COMPAT_V2_W_FEATURE = new IcebergCompatV2TableFeature();
    public static final TableFeature TYPE_WIDENING_RW_FEATURE = new TypeWideningTableFeature();
    public static final TableFeature TYPE_WIDENING_RW_PREVIEW_FEATURE = new TypeWideningTableFeatureBase("typeWidening-preview");
    public static final TableFeature IN_COMMIT_TIMESTAMP_W_FEATURE = new InCommitTimestampTableFeature();
    public static final TableFeature TIMESTAMP_NTZ_RW_FEATURE = new TimestampNtzTableFeature();
    public static final TableFeature CHECKPOINT_V2_RW_FEATURE = new CheckpointV2TableFeature();
    public static final TableFeature VACUUM_PROTOCOL_CHECK_RW_FEATURE = new VacuumProtocolCheckTableFeature();
    public static final TableFeature ICEBERG_WRITER_COMPAT_V1 = new IcebergWriterCompatV1();
    public static final int TABLE_FEATURES_MIN_READER_VERSION = 3;
    public static final int TABLE_FEATURES_MIN_WRITER_VERSION = 7;
    public static final List<TableFeature> TABLE_FEATURES = Collections.unmodifiableList(Arrays.asList(APPEND_ONLY_W_FEATURE, CHECKPOINT_V2_RW_FEATURE, CHANGE_DATA_FEED_W_FEATURE, CLUSTERING_W_FEATURE, COLUMN_MAPPING_RW_FEATURE, CONSTRAINTS_W_FEATURE, DELETION_VECTORS_RW_FEATURE, GENERATED_COLUMNS_W_FEATURE, DOMAIN_METADATA_W_FEATURE, ICEBERG_COMPAT_V2_W_FEATURE, IDENTITY_COLUMNS_W_FEATURE, IN_COMMIT_TIMESTAMP_W_FEATURE, INVARIANTS_W_FEATURE, ROW_TRACKING_W_FEATURE, TIMESTAMP_NTZ_RW_FEATURE, TYPE_WIDENING_RW_PREVIEW_FEATURE, TYPE_WIDENING_RW_FEATURE, VACUUM_PROTOCOL_CHECK_RW_FEATURE, VARIANT_RW_FEATURE, VARIANT_RW_PREVIEW_FEATURE, VARIANT_SHREDDING_PREVIEW_RW_FEATURE, ICEBERG_WRITER_COMPAT_V1));
    public static final Map<String, TableFeature> TABLE_FEATURE_MAP = Collections.unmodifiableMap(new CaseInsensitiveMap<TableFeature>(){
        {
            for (TableFeature tableFeature : TABLE_FEATURES) {
                this.put(tableFeature.featureName(), tableFeature);
            }
        }
    });

    public static TableFeature getTableFeature(String string) {
        TableFeature tableFeature = TABLE_FEATURE_MAP.get(string);
        if (tableFeature == null) {
            throw DeltaErrors.unsupportedTableFeature(string);
        }
        return tableFeature;
    }

    public static boolean supportsReaderFeatures(int n) {
        return n >= 3;
    }

    public static boolean supportsWriterFeatures(int n) {
        return n >= 7;
    }

    public static Tuple2<Integer, Integer> minimumRequiredVersions(Set<TableFeature> set) {
        int n = set.stream().mapToInt(TableFeature::minReaderVersion).max().orElse(0);
        int n2 = set.stream().mapToInt(TableFeature::minWriterVersion).max().orElse(0);
        return new Tuple2<Integer, Integer>(Math.max(n, 1), Math.max(n2, 1));
    }

    public static Optional<Tuple2<Protocol, Set<TableFeature>>> autoUpgradeProtocolBasedOnMetadata(Metadata metadata, Collection<TableFeature> collection, Protocol protocol) {
        Protocol protocol2;
        Set<TableFeature> set = TableFeatures.extractAllNeededTableFeatures(metadata, protocol);
        if (collection != null && !collection.isEmpty()) {
            set = Stream.concat(set.stream(), collection.stream()).collect(Collectors.toSet());
        }
        if (!(protocol2 = new Protocol(3, 7).withFeatures(set).normalized()).canUpgradeTo(protocol)) {
            HashSet<TableFeature> hashSet = new HashSet<TableFeature>(protocol2.getImplicitlyAndExplicitlySupportedFeatures());
            hashSet.removeAll(protocol.getImplicitlyAndExplicitlySupportedFeatures());
            return Optional.of(new Tuple2<Protocol, HashSet<TableFeature>>(protocol2.merge(protocol), hashSet));
        }
        return Optional.empty();
    }

    public static Tuple2<Set<TableFeature>, Optional<Metadata>> extractFeaturePropertyOverrides(Metadata metadata) {
        HashSet<TableFeature> hashSet = new HashSet<TableFeature>();
        Map<String, String> map = metadata.getConfiguration();
        for (Map.Entry<String, String> entry2 : map.entrySet()) {
            if (!entry2.getKey().startsWith(SET_TABLE_FEATURE_SUPPORTED_PREFIX)) continue;
            String string = entry2.getKey().substring(SET_TABLE_FEATURE_SUPPORTED_PREFIX.length());
            TableFeature tableFeature = TableFeatures.getTableFeature(string);
            hashSet.add(tableFeature);
            if (entry2.getValue().equals("supported")) continue;
            throw DeltaErrors.invalidConfigurationValueException(entry2.getKey(), entry2.getValue(), "TableFeature override options may only have \"supported\" as there value");
        }
        if (hashSet.isEmpty()) {
            return new Tuple2<Set<TableFeature>, Optional<Metadata>>(hashSet, Optional.empty());
        }
        Map<String, String> map2 = map.entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith(SET_TABLE_FEATURE_SUPPORTED_PREFIX)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new Tuple2<Set<TableFeature>, Optional<Metadata>>(hashSet, Optional.of(metadata.withReplacedConfiguration(map2)));
    }

    public static void validateKernelCanReadTheTable(Protocol protocol, String string) {
        if (protocol.getMinReaderVersion() > 3) {
            throw DeltaErrors.unsupportedReaderProtocol(string, protocol.getMinReaderVersion());
        }
        Set set = protocol.getImplicitlyAndExplicitlySupportedReaderWriterFeatures().stream().filter(tableFeature -> !tableFeature.hasKernelReadSupport()).collect(Collectors.toSet());
        if (!set.isEmpty()) {
            throw DeltaErrors.unsupportedReaderFeatures(string, set.stream().map(TableFeature::featureName).collect(Collectors.toSet()));
        }
    }

    public static void validateKernelCanWriteToTable(Protocol protocol, Metadata metadata, String string) {
        TableFeatures.validateKernelCanReadTheTable(protocol, string);
        if (protocol.getMinWriterVersion() > 7) {
            throw DeltaErrors.unsupportedWriterProtocol(string, protocol.getMinWriterVersion());
        }
        Set set = protocol.getImplicitlyAndExplicitlySupportedFeatures().stream().filter(tableFeature -> !tableFeature.hasKernelWriteSupport(metadata)).collect(Collectors.toSet());
        if (!set.isEmpty()) {
            throw DeltaErrors.unsupportedWriterFeatures(string, set.stream().map(TableFeature::featureName).collect(Collectors.toSet()));
        }
    }

    public static boolean isRowTrackingSupported(Protocol protocol) {
        return protocol.getImplicitlyAndExplicitlySupportedFeatures().contains(ROW_TRACKING_W_FEATURE);
    }

    public static boolean isDomainMetadataSupported(Protocol protocol) {
        return protocol.getImplicitlyAndExplicitlySupportedFeatures().contains(DOMAIN_METADATA_W_FEATURE);
    }

    public static boolean hasInvariants(StructType structType) {
        return !SchemaUtils.filterRecursively(structType, false, true, structField -> structField.getMetadata().contains("delta.invariants")).isEmpty();
    }

    public static boolean hasCheckConstraints(Metadata metadata) {
        return metadata.getConfiguration().keySet().stream().anyMatch(string -> string.startsWith("delta.constraints."));
    }

    public static boolean isClusteringTableFeatureSupported(Protocol protocol) {
        return protocol.supportsFeature(CLUSTERING_W_FEATURE);
    }

    public static boolean hasIdentityColumns(Metadata metadata) {
        return !SchemaUtils.filterRecursively(metadata.getSchema(), false, true, structField -> {
            FieldMetadata fieldMetadata = structField.getMetadata();
            boolean bl = fieldMetadata.contains("delta.identity.start");
            boolean bl2 = fieldMetadata.contains("delta.identity.step");
            boolean bl3 = fieldMetadata.contains("delta.identity.allowExplicitInsert");
            if (bl != bl2 || bl != bl3) {
                throw new KernelException(String.format("Inconsistent IDENTITY metadata for column %s detected: %s, %s, %s", structField.getName(), bl, bl2, bl3));
            }
            return bl && bl2 && bl3;
        }).isEmpty();
    }

    public static boolean hasGeneratedColumns(Metadata metadata) {
        return !SchemaUtils.filterRecursively(metadata.getSchema(), false, true, structField -> structField.getMetadata().contains("delta.generationExpression")).isEmpty();
    }

    private static Set<TableFeature> extractAllNeededTableFeatures(Metadata metadata, Protocol protocol) {
        Set<TableFeature> set = protocol.getImplicitlyAndExplicitlySupportedFeatures();
        Set<TableFeature> set2 = TABLE_FEATURES.stream().filter(tableFeature -> tableFeature instanceof FeatureAutoEnabledByMetadata).filter(tableFeature -> ((FeatureAutoEnabledByMetadata)((Object)tableFeature)).metadataRequiresFeatureToBeEnabled(protocol, metadata)).collect(Collectors.toSet());
        Set<TableFeature> set3 = TableFeatures.getDependencyFeatures(set2);
        return Stream.concat(set.stream(), set3.stream()).collect(Collectors.toSet());
    }

    private static Set<TableFeature> getDependencyFeatures(Set<TableFeature> set) {
        HashSet<TableFeature> hashSet = new HashSet<TableFeature>(set);
        set.forEach(tableFeature -> hashSet.addAll(tableFeature.requiredFeatures()));
        if (set.equals(hashSet)) {
            return set;
        }
        return TableFeatures.getDependencyFeatures(hashSet);
    }

    private static boolean hasTypeColumn(StructType structType, DataType dataType) {
        return !SchemaUtils.filterRecursively(structType, true, true, structField -> structField.getDataType().equals(dataType)).isEmpty();
    }

    private static class AppendOnlyFeature
    extends TableFeature.LegacyWriterFeature {
        AppendOnlyFeature() {
            super("appendOnly", 2);
        }

        @Override
        public boolean metadataRequiresFeatureToBeEnabled(Protocol protocol, Metadata metadata) {
            return TableConfig.APPEND_ONLY_ENABLED.fromMetadata(metadata);
        }

        @Override
        public boolean hasKernelWriteSupport(Metadata metadata) {
            return true;
        }
    }

    private static class InvariantsFeature
    extends TableFeature.LegacyWriterFeature {
        InvariantsFeature() {
            super("invariants", 2);
        }

        @Override
        public boolean metadataRequiresFeatureToBeEnabled(Protocol protocol, Metadata metadata) {
            return TableFeatures.hasInvariants(metadata.getSchema());
        }

        @Override
        public boolean hasKernelWriteSupport(Metadata metadata) {
            return !TableFeatures.hasInvariants(metadata.getSchema());
        }
    }

    private static class ConstraintsFeature
    extends TableFeature.LegacyWriterFeature {
        ConstraintsFeature() {
            super("checkConstraints", 3);
        }

        @Override
        public boolean hasKernelWriteSupport(Metadata metadata) {
            return !TableFeatures.hasCheckConstraints(metadata);
        }

        @Override
        public boolean metadataRequiresFeatureToBeEnabled(Protocol protocol, Metadata metadata) {
            return TableFeatures.hasCheckConstraints(metadata);
        }
    }

    private static class ChangeDataFeedFeature
    extends TableFeature.LegacyWriterFeature {
        ChangeDataFeedFeature() {
            super("changeDataFeed", 4);
        }

        @Override
        public boolean hasKernelWriteSupport(Metadata metadata) {
            return TableConfig.CHANGE_DATA_FEED_ENABLED.fromMetadata(metadata) == false;
        }

        @Override
        public boolean metadataRequiresFeatureToBeEnabled(Protocol protocol, Metadata metadata) {
            return TableConfig.CHANGE_DATA_FEED_ENABLED.fromMetadata(metadata);
        }
    }

    private static class ColumnMappingFeature
    extends TableFeature.LegacyReaderWriterFeature {
        ColumnMappingFeature() {
            super("columnMapping", 2, 5);
        }

        @Override
        public boolean metadataRequiresFeatureToBeEnabled(Protocol protocol, Metadata metadata) {
            return TableConfig.COLUMN_MAPPING_MODE.fromMetadata(metadata) != ColumnMapping.ColumnMappingMode.NONE;
        }
    }

    private static class GeneratedColumnsFeature
    extends TableFeature.LegacyWriterFeature {
        GeneratedColumnsFeature() {
            super("generatedColumns", 4);
        }

        @Override
        public boolean hasKernelWriteSupport(Metadata metadata) {
            return !TableFeatures.hasGeneratedColumns(metadata);
        }

        @Override
        public boolean metadataRequiresFeatureToBeEnabled(Protocol protocol, Metadata metadata) {
            return TableFeatures.hasGeneratedColumns(metadata);
        }
    }

    private static class IdentityColumnsFeature
    extends TableFeature.LegacyWriterFeature {
        IdentityColumnsFeature() {
            super("identityColumns", 6);
        }

        @Override
        public boolean hasKernelWriteSupport(Metadata metadata) {
            return !TableFeatures.hasIdentityColumns(metadata);
        }

        @Override
        public boolean metadataRequiresFeatureToBeEnabled(Protocol protocol, Metadata metadata) {
            return TableFeatures.hasIdentityColumns(metadata);
        }
    }

    private static class VariantTypeTableFeature
    extends VariantTypeTableFeatureBase
    implements FeatureAutoEnabledByMetadata {
        VariantTypeTableFeature() {
            super("variantType");
        }

        @Override
        public boolean metadataRequiresFeatureToBeEnabled(Protocol protocol, Metadata metadata) {
            return TableFeatures.hasTypeColumn(metadata.getSchema(), VariantType.VARIANT) && !protocol.supportsFeature(VARIANT_RW_PREVIEW_FEATURE);
        }
    }

    private static class VariantTypeTableFeatureBase
    extends TableFeature.ReaderWriterFeature {
        VariantTypeTableFeatureBase(String string) {
            super(string, 3, 7);
        }

        @Override
        public boolean hasKernelWriteSupport(Metadata metadata) {
            return false;
        }
    }

    private static class VariantShreddingPreviewFeature
    extends TableFeature.ReaderWriterFeature
    implements FeatureAutoEnabledByMetadata {
        VariantShreddingPreviewFeature() {
            super("variantShredding-preview", 3, 7);
        }

        @Override
        public boolean metadataRequiresFeatureToBeEnabled(Protocol protocol, Metadata metadata) {
            return TableConfig.VARIANT_SHREDDING_ENABLED.fromMetadata(metadata);
        }

        @Override
        public boolean hasKernelWriteSupport(Metadata metadata) {
            return false;
        }
    }

    private static class DomainMetadataFeature
    extends TableFeature.WriterFeature {
        DomainMetadataFeature() {
            super("domainMetadata", 7);
        }
    }

    private static class ClusteringTableFeature
    extends TableFeature.WriterFeature {
        ClusteringTableFeature() {
            super("clustering", 7);
        }

        @Override
        public Set<TableFeature> requiredFeatures() {
            return Collections.singleton(DOMAIN_METADATA_W_FEATURE);
        }
    }

    private static class RowTrackingFeature
    extends TableFeature.WriterFeature
    implements FeatureAutoEnabledByMetadata {
        RowTrackingFeature() {
            super("rowTracking", 7);
        }

        @Override
        public boolean metadataRequiresFeatureToBeEnabled(Protocol protocol, Metadata metadata) {
            return TableConfig.ROW_TRACKING_ENABLED.fromMetadata(metadata);
        }

        @Override
        public Set<TableFeature> requiredFeatures() {
            return Collections.singleton(DOMAIN_METADATA_W_FEATURE);
        }
    }

    private static class DeletionVectorsTableFeature
    extends TableFeature.ReaderWriterFeature
    implements FeatureAutoEnabledByMetadata {
        DeletionVectorsTableFeature() {
            super("deletionVectors", 3, 7);
        }

        @Override
        public boolean metadataRequiresFeatureToBeEnabled(Protocol protocol, Metadata metadata) {
            return TableConfig.DELETION_VECTORS_CREATION_ENABLED.fromMetadata(metadata);
        }
    }

    private static class IcebergCompatV2TableFeature
    extends TableFeature.WriterFeature
    implements FeatureAutoEnabledByMetadata {
        IcebergCompatV2TableFeature() {
            super("icebergCompatV2", 7);
        }

        @Override
        public boolean metadataRequiresFeatureToBeEnabled(Protocol protocol, Metadata metadata) {
            return TableConfig.ICEBERG_COMPAT_V2_ENABLED.fromMetadata(metadata);
        }

        @Override
        public Set<TableFeature> requiredFeatures() {
            return Collections.singleton(COLUMN_MAPPING_RW_FEATURE);
        }
    }

    private static class TypeWideningTableFeature
    extends TypeWideningTableFeatureBase
    implements FeatureAutoEnabledByMetadata {
        TypeWideningTableFeature() {
            super("typeWidening");
        }

        @Override
        public boolean metadataRequiresFeatureToBeEnabled(Protocol protocol, Metadata metadata) {
            return TableConfig.TYPE_WIDENING_ENABLED.fromMetadata(metadata) != false && !protocol.supportsFeature(TYPE_WIDENING_RW_PREVIEW_FEATURE);
        }
    }

    private static class TypeWideningTableFeatureBase
    extends TableFeature.ReaderWriterFeature {
        TypeWideningTableFeatureBase(String string) {
            super(string, 3, 7);
        }

        @Override
        public boolean hasKernelWriteSupport(Metadata metadata) {
            return false;
        }
    }

    private static class InCommitTimestampTableFeature
    extends TableFeature.WriterFeature
    implements FeatureAutoEnabledByMetadata {
        InCommitTimestampTableFeature() {
            super("inCommitTimestamp", 7);
        }

        @Override
        public boolean metadataRequiresFeatureToBeEnabled(Protocol protocol, Metadata metadata) {
            return TableConfig.IN_COMMIT_TIMESTAMPS_ENABLED.fromMetadata(metadata);
        }
    }

    private static class TimestampNtzTableFeature
    extends TableFeature.ReaderWriterFeature
    implements FeatureAutoEnabledByMetadata {
        TimestampNtzTableFeature() {
            super("timestampNtz", 3, 7);
        }

        @Override
        public boolean metadataRequiresFeatureToBeEnabled(Protocol protocol, Metadata metadata) {
            return TableFeatures.hasTypeColumn(metadata.getSchema(), TimestampNTZType.TIMESTAMP_NTZ);
        }
    }

    private static class CheckpointV2TableFeature
    extends TableFeature.ReaderWriterFeature
    implements FeatureAutoEnabledByMetadata {
        CheckpointV2TableFeature() {
            super("v2Checkpoint", 3, 7);
        }

        @Override
        public boolean metadataRequiresFeatureToBeEnabled(Protocol protocol, Metadata metadata) {
            return "v2".equals(TableConfig.CHECKPOINT_POLICY.fromMetadata(metadata));
        }
    }

    private static class VacuumProtocolCheckTableFeature
    extends TableFeature.ReaderWriterFeature {
        VacuumProtocolCheckTableFeature() {
            super("vacuumProtocolCheck", 3, 7);
        }
    }

    private static class IcebergWriterCompatV1
    extends TableFeature.WriterFeature
    implements FeatureAutoEnabledByMetadata {
        IcebergWriterCompatV1() {
            super("icebergWriterCompatV1", 7);
        }

        @Override
        public boolean metadataRequiresFeatureToBeEnabled(Protocol protocol, Metadata metadata) {
            return TableConfig.ICEBERG_WRITER_COMPAT_V1_ENABLED.fromMetadata(metadata);
        }

        @Override
        public Set<TableFeature> requiredFeatures() {
            return Collections.singleton(ICEBERG_COMPAT_V2_W_FEATURE);
        }
    }
}

