/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.util;

import io.delta.kernel.internal.util.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class CaseInsensitiveMap<V>
implements Map<String, V> {
    private final Map<String, V> innerMap = new HashMap<String, V>();

    @Override
    public V get(Object object) {
        return this.innerMap.get(this.toLowerCase(object));
    }

    @Override
    public V put(String string, V v) {
        return this.innerMap.put(this.toLowerCase(string), v);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> map) {
        throw new UnsupportedOperationException("putAll");
    }

    @Override
    public V remove(Object object) {
        return this.innerMap.remove(this.toLowerCase(object));
    }

    @Override
    public boolean containsKey(Object object) {
        return this.innerMap.containsKey(this.toLowerCase(object));
    }

    @Override
    public boolean containsValue(Object object) {
        return this.innerMap.containsValue(object);
    }

    @Override
    public Set<String> keySet() {
        return this.innerMap.keySet();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return this.innerMap.entrySet();
    }

    @Override
    public Collection<V> values() {
        return this.innerMap.values();
    }

    @Override
    public int size() {
        return this.innerMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.innerMap.isEmpty();
    }

    @Override
    public void clear() {
        this.innerMap.clear();
    }

    private String toLowerCase(Object object) {
        if (object == null) {
            return null;
        }
        Preconditions.checkArgument(object instanceof String, "Key must be a string");
        return ((String)object).toLowerCase(Locale.ROOT);
    }
}

