/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.util;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.actions.DomainMetadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.tablefeatures.TableFeatures;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DomainMetadataUtils {
    private DomainMetadataUtils() {
    }

    public static void populateDomainMetadataMap(ColumnVector columnVector, Map<String, DomainMetadata> map) {
        int n = columnVector.getSize();
        for (int i = 0; i < n; ++i) {
            DomainMetadata domainMetadata = DomainMetadata.fromColumnVector(columnVector, i);
            if (domainMetadata == null || map.containsKey(domainMetadata.getDomain())) continue;
            map.put(domainMetadata.getDomain(), domainMetadata);
        }
    }

    public static void validateDomainMetadatas(List<DomainMetadata> list, Protocol protocol) {
        if (list.isEmpty()) {
            return;
        }
        if (!TableFeatures.isDomainMetadataSupported(protocol)) {
            throw DeltaErrors.domainMetadataUnsupported();
        }
        HashMap<String, DomainMetadata> hashMap = new HashMap<String, DomainMetadata>();
        for (DomainMetadata domainMetadata : list) {
            String string = domainMetadata.getDomain();
            if (hashMap.containsKey(string)) {
                String string2 = String.format("Multiple actions detected for domain '%s' in single transaction: '%s' and '%s'. Only one action per domain is allowed.", string, ((DomainMetadata)hashMap.get(string)).toString(), domainMetadata.toString());
                throw new IllegalArgumentException(string2);
            }
            hashMap.put(string, domainMetadata);
        }
    }
}

