/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.util;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.Row;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.utils.CloseableIterator;
import java.io.IOException;
import java.net.URI;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class InternalUtils {
    private static final LocalDate EPOCH_DAY = LocalDate.ofEpochDay(0L);
    private static final LocalDateTime EPOCH_DATETIME = LocalDateTime.ofEpochSecond(0L, 0, ZoneOffset.UTC);

    private InternalUtils() {
    }

    public static Optional<Row> getSingularRow(CloseableIterator<ColumnarBatch> closeableIterator) throws IOException {
        Row row = null;
        while (closeableIterator.hasNext()) {
            CloseableIterator<Row> closeableIterator2 = closeableIterator.next().getRows();
            try {
                while (closeableIterator2.hasNext()) {
                    if (row != null) {
                        throw new IllegalArgumentException("Given data batch contains more than one row");
                    }
                    row = closeableIterator2.next();
                }
            }
            finally {
                if (closeableIterator2 == null) continue;
                closeableIterator2.close();
            }
        }
        return Optional.ofNullable(row);
    }

    public static <T> Optional<T> getSingularElement(CloseableIterator<T> closeableIterator) throws IOException {
        try {
            Object t = null;
            while (closeableIterator.hasNext()) {
                if (t != null) {
                    throw new IllegalArgumentException("Iterator contains more than one element");
                }
                t = closeableIterator.next();
            }
            Optional<Object> optional = Optional.ofNullable(t);
            return optional;
        }
        finally {
            closeableIterator.close();
        }
    }

    public static int daysSinceEpoch(Date date) {
        LocalDate localDate = date.toLocalDate();
        return (int)localDate.toEpochDay();
    }

    public static long microsSinceEpoch(Timestamp timestamp) {
        LocalDateTime localDateTime = timestamp.toLocalDateTime();
        return ChronoUnit.MICROS.between(EPOCH_DATETIME, localDateTime);
    }

    public static ColumnVector singletonStringColumnVector(final String string) {
        return new ColumnVector(){

            @Override
            public DataType getDataType() {
                return StringType.STRING;
            }

            @Override
            public int getSize() {
                return 1;
            }

            @Override
            public void close() {
            }

            @Override
            public boolean isNullAt(int n) {
                return string == null;
            }

            @Override
            public String getString(int n) {
                if (n != 0) {
                    throw new IllegalArgumentException("Invalid row id: " + n);
                }
                return string;
            }
        };
    }

    public static Row requireNonNull(Row row, int n, String string) {
        if (row.isNullAt(n)) {
            throw new IllegalArgumentException("Expected a non-null value for column: " + string);
        }
        return row;
    }

    public static ColumnVector requireNonNull(ColumnVector columnVector, int n, String string) {
        if (columnVector.isNullAt(n)) {
            throw new IllegalArgumentException("Expected a non-null value for column: " + string);
        }
        return columnVector;
    }

    public static Path relativizePath(Path path, URI uRI) {
        if (path.isAbsolute()) {
            return new Path(uRI.relativize(path.toUri()));
        }
        return path;
    }

    public static Set<String> toLowerCaseSet(Collection<String> collection) {
        return collection.stream().map(String::toLowerCase).collect(Collectors.toSet());
    }
}

