/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.util;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.MapValue;
import io.delta.kernel.engine.ExpressionHandler;
import io.delta.kernel.expressions.AlwaysFalse;
import io.delta.kernel.expressions.AlwaysTrue;
import io.delta.kernel.expressions.And;
import io.delta.kernel.expressions.Column;
import io.delta.kernel.expressions.Expression;
import io.delta.kernel.expressions.ExpressionEvaluator;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.expressions.PartitionValueExpression;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.expressions.ScalarExpression;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.DeltaErrorsInternal;
import io.delta.kernel.internal.InternalScanFileUtils;
import io.delta.kernel.internal.annotation.VisibleForTesting;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.util.ColumnMapping;
import io.delta.kernel.internal.util.InternalUtils;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.SchemaUtils;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.types.TimestampNTZType;
import io.delta.kernel.types.TimestampType;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class PartitionUtils {
    private static final DateTimeFormatter PARTITION_TIMESTAMP_FORMATTER;
    private static final BitSet CHARS_TO_ESCAPE;

    private PartitionUtils() {
    }

    public static StructType physicalSchemaWithoutPartitionColumns(final StructType structType, final StructType structType2, Set<String> set) {
        if (set == null || set.size() == 0) {
            return structType2;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(){
            {
                IntStream.range(0, structType.length()).mapToObj(n -> new Tuple2<StructField, StructField>(structType.at(n), structType2.at(n))).forEach((? super T tuple2) -> this.put(((StructField)tuple2._2).getName(), ((StructField)tuple2._1).getName()));
            }
        };
        return new StructType(structType2.fields().stream().filter(structField -> !set.contains(hashMap.get(structField.getName()))).collect(Collectors.toList()));
    }

    public static ColumnarBatch withPartitionColumns(ExpressionHandler expressionHandler, ColumnarBatch columnarBatch, Map<String, String> map, StructType structType) {
        if (map == null || map.size() == 0) {
            return columnarBatch;
        }
        for (int i = 0; i < structType.length(); ++i) {
            StructField structField = structType.at(i);
            if (!map.containsKey(structField.getName())) continue;
            ColumnarBatch columnarBatch2 = columnarBatch;
            ExpressionEvaluator expressionEvaluator = DeltaErrors.wrapEngineException(() -> expressionHandler.getEvaluator(columnarBatch2.getSchema(), PartitionUtils.literalForPartitionValue(structField.getDataType(), (String)map.get(structField.getName())), structField.getDataType()), "Get the expression evaluator for partition column %s with datatype=%s and value=%s", structField.getName(), structField.getDataType(), map.get(structField.getName()));
            ColumnVector columnVector = DeltaErrors.wrapEngineException(() -> expressionEvaluator.eval(columnarBatch2), "Evaluating the partition value expression %s", PartitionUtils.literalForPartitionValue(structField.getDataType(), map.get(structField.getName())));
            columnarBatch = columnarBatch.withNewColumn(i, structField, columnVector);
        }
        return columnarBatch;
    }

    public static MapValue serializePartitionMap(Map<String, Literal> map) {
        if (map == null || map.isEmpty()) {
            return VectorUtils.stringStringMapValue(Collections.emptyMap());
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, Literal> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), PartitionUtils.serializePartitionValue(entry.getValue()));
        }
        return VectorUtils.stringStringMapValue(hashMap);
    }

    public static Map<String, Literal> validateAndSanitizePartitionValues(StructType structType, List<String> list, Map<String, Literal> map) {
        if (!InternalUtils.toLowerCaseSet(list).equals(InternalUtils.toLowerCaseSet(map.keySet()))) {
            throw new IllegalArgumentException(String.format("Partition values provided are not matching the partition columns. Partition columns: %s, Partition values: %s", list, map));
        }
        Map<String, Literal> map2 = SchemaUtils.casePreservingPartitionColNames(list, map);
        map2.entrySet().forEach(entry -> {
            String string = (String)entry.getKey();
            Literal literal = (Literal)entry.getValue();
            StructField structField = structType.get(string);
            Preconditions.checkArgument(structField != null, "Partition column %s is not present in the table schema", string);
            DataType dataType = structField.getDataType();
            if (!dataType.equivalent(literal.getDataType())) {
                throw new IllegalArgumentException(String.format("Partition column %s is of type %s but the value provided is of type %s", string, dataType, literal.getDataType()));
            }
        });
        return map2;
    }

    public static void validatePredicateOnlyOnPartitionColumns(Predicate predicate, Set<String> set) {
        Tuple2<Predicate, Predicate> tuple2 = PartitionUtils.splitMetadataAndDataPredicates(predicate, set);
        Predicate predicate2 = (Predicate)tuple2._1;
        Predicate predicate3 = (Predicate)tuple2._2;
        if (predicate2 == AlwaysTrue.ALWAYS_TRUE) {
            throw new IllegalArgumentException(String.format("Partition predicate must contain at least one partition column: %s", predicate));
        }
        if (predicate3 != AlwaysTrue.ALWAYS_TRUE) {
            throw new IllegalArgumentException(String.format("Partition predicate must contain only partition columns: %s", predicate));
        }
    }

    public static Tuple2<Predicate, Predicate> splitMetadataAndDataPredicates(Predicate predicate, Set<String> set) {
        String string = predicate.getName();
        List<Expression> list = predicate.getChildren();
        if ("AND".equalsIgnoreCase(string)) {
            Predicate predicate2 = (Predicate)list.get(0);
            Predicate predicate3 = (Predicate)list.get(1);
            Tuple2<Predicate, Predicate> tuple2 = PartitionUtils.splitMetadataAndDataPredicates(predicate2, set);
            Tuple2<Predicate, Predicate> tuple22 = PartitionUtils.splitMetadataAndDataPredicates(predicate3, set);
            return new Tuple2<Predicate, Predicate>(PartitionUtils.combineWithAndOp((Predicate)tuple2._1, (Predicate)tuple22._1), PartitionUtils.combineWithAndOp((Predicate)tuple2._2, (Predicate)tuple22._2));
        }
        if (PartitionUtils.hasNonPartitionColumns(list, set)) {
            return new Tuple2<Predicate, Predicate>(AlwaysTrue.ALWAYS_TRUE, predicate);
        }
        return new Tuple2<Predicate, Predicate>(predicate, AlwaysTrue.ALWAYS_TRUE);
    }

    public static Predicate rewritePartitionPredicateOnCheckpointFileSchema(Predicate predicate, Map<String, StructField> map) {
        return new Predicate(predicate.getName(), predicate.getChildren().stream().map(expression -> PartitionUtils.rewriteColRefOnPartitionValuesParsed(expression, map)).collect(Collectors.toList()));
    }

    private static Expression rewriteColRefOnPartitionValuesParsed(Expression expression, Map<String, StructField> map) {
        if (expression instanceof Column) {
            Column column = (Column)expression;
            String string = column.getNames()[0];
            StructField structField = map.get(string.toLowerCase(Locale.ROOT));
            if (structField == null) {
                throw new IllegalArgumentException(string + " is not present in metadata");
            }
            String string2 = ColumnMapping.getPhysicalName(structField);
            return InternalScanFileUtils.getPartitionValuesParsedRefInAddFile(string2);
        }
        if (expression instanceof Predicate) {
            return PartitionUtils.rewritePartitionPredicateOnCheckpointFileSchema((Predicate)expression, map);
        }
        return expression;
    }

    public static Predicate rewritePartitionPredicateOnScanFileSchema(Predicate predicate, Map<String, StructField> map) {
        return new Predicate(predicate.getName(), predicate.getChildren().stream().map(expression -> PartitionUtils.rewritePartitionColumnRef(expression, map)).collect(Collectors.toList()));
    }

    private static Expression rewritePartitionColumnRef(Expression expression, Map<String, StructField> map) {
        Column column = InternalScanFileUtils.ADD_FILE_PARTITION_COL_REF;
        if (expression instanceof Column) {
            Column column2 = (Column)expression;
            String string = column2.getNames()[0];
            StructField structField = map.get(string.toLowerCase(Locale.ROOT));
            if (structField == null) {
                throw new IllegalArgumentException(string + " is not present in metadata");
            }
            DataType dataType = structField.getDataType();
            String string2 = ColumnMapping.getPhysicalName(structField);
            ScalarExpression scalarExpression = new ScalarExpression("element_at", Arrays.asList(column, Literal.ofString(string2)));
            if (dataType instanceof StringType) {
                return scalarExpression;
            }
            return new PartitionValueExpression(scalarExpression, dataType);
        }
        if (expression instanceof Predicate) {
            return PartitionUtils.rewritePartitionPredicateOnScanFileSchema((Predicate)expression, map);
        }
        return expression;
    }

    public static String getTargetDirectory(String string, List<String> list, Map<String, Literal> map) {
        Path path = new Path(string);
        for (String string2 : list) {
            Literal literal = map.get(string2);
            Preconditions.checkArgument(literal != null, "Partition column value is missing for column: %s", string2);
            String string3 = PartitionUtils.serializePartitionValue(literal);
            string3 = string3 == null ? "__HIVE_DEFAULT_PARTITION__" : PartitionUtils.escapePartitionValue(string3);
            String string4 = string2 + "=" + string3;
            path = new Path(path, string4);
        }
        return path.toString();
    }

    private static boolean hasNonPartitionColumns(List<Expression> list, Set<String> set) {
        for (Expression expression : list) {
            String[] stringArray;
            if (!(expression instanceof Column ? (stringArray = ((Column)expression).getNames()).length != 1 || !set.contains(stringArray[0].toLowerCase(Locale.ROOT)) : PartitionUtils.hasNonPartitionColumns(expression.getChildren(), set))) continue;
            return true;
        }
        return false;
    }

    private static Predicate combineWithAndOp(Predicate predicate, Predicate predicate2) {
        String string = predicate.getName().toUpperCase();
        String string2 = predicate2.getName().toUpperCase();
        if (string.equals("ALWAYS_FALSE") || string2.equals("ALWAYS_FALSE")) {
            return AlwaysFalse.ALWAYS_FALSE;
        }
        if (string.equals("ALWAYS_TRUE")) {
            return predicate2;
        }
        if (string2.equals("ALWAYS_TRUE")) {
            return predicate;
        }
        return new And(predicate, predicate2);
    }

    private static Optional<Long> tryParseStandardTimestamp(String string) {
        try {
            Timestamp timestamp = Timestamp.valueOf(string);
            return Optional.of(InternalUtils.microsSinceEpoch(timestamp));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Optional.empty();
        }
    }

    private static Optional<Long> tryParseIsoTimestamp(String string) {
        try {
            Instant instant = Instant.parse(string);
            long l = TimeUnit.MILLISECONDS.toMicros(instant.toEpochMilli());
            return Optional.of(l);
        }
        catch (DateTimeParseException dateTimeParseException) {
            return Optional.empty();
        }
    }

    @VisibleForTesting
    static Literal tryParseTimestamp(String string) {
        Optional<Long> optional = PartitionUtils.tryParseStandardTimestamp(string);
        if (!optional.isPresent()) {
            optional = PartitionUtils.tryParseIsoTimestamp(string);
        }
        return optional.map(Literal::ofTimestamp).orElseThrow(() -> DeltaErrorsInternal.invalidTimestampFormatForPartitionValue(string));
    }

    protected static Literal literalForPartitionValue(DataType dataType, String string) {
        if (string == null) {
            return Literal.ofNull(dataType);
        }
        if (dataType instanceof BooleanType) {
            return Literal.ofBoolean(Boolean.parseBoolean(string));
        }
        if (dataType instanceof ByteType) {
            return Literal.ofByte(Byte.parseByte(string));
        }
        if (dataType instanceof ShortType) {
            return Literal.ofShort(Short.parseShort(string));
        }
        if (dataType instanceof IntegerType) {
            return Literal.ofInt(Integer.parseInt(string));
        }
        if (dataType instanceof LongType) {
            return Literal.ofLong(Long.parseLong(string));
        }
        if (dataType instanceof FloatType) {
            return Literal.ofFloat(Float.parseFloat(string));
        }
        if (dataType instanceof DoubleType) {
            return Literal.ofDouble(Double.parseDouble(string));
        }
        if (dataType instanceof StringType) {
            return Literal.ofString(string);
        }
        if (dataType instanceof BinaryType) {
            return Literal.ofBinary(string.getBytes());
        }
        if (dataType instanceof DateType) {
            return Literal.ofDate(InternalUtils.daysSinceEpoch(Date.valueOf(string)));
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return Literal.ofDecimal(new BigDecimal(string), decimalType.getPrecision(), decimalType.getScale());
        }
        if (dataType instanceof TimestampType) {
            return PartitionUtils.tryParseTimestamp(string);
        }
        if (dataType instanceof TimestampNTZType) {
            return Literal.ofTimestampNtz(InternalUtils.microsSinceEpoch(Timestamp.valueOf(string)));
        }
        throw new UnsupportedOperationException("Unsupported partition column: " + dataType);
    }

    protected static String serializePartitionValue(Literal literal) {
        Object object = literal.getValue();
        if (object == null) {
            return null;
        }
        DataType dataType = literal.getDataType();
        if (dataType instanceof ByteType || dataType instanceof ShortType || dataType instanceof IntegerType || dataType instanceof LongType || dataType instanceof FloatType || dataType instanceof DoubleType || dataType instanceof BooleanType) {
            return String.valueOf(object);
        }
        if (dataType instanceof StringType) {
            return (String)object;
        }
        if (dataType instanceof DateType) {
            int n = (Integer)object;
            return LocalDate.ofEpochDay(n).toString();
        }
        if (dataType instanceof TimestampType || dataType instanceof TimestampNTZType) {
            long l = (Long)object;
            long l2 = l / 1000000L;
            int n = (int)(l % 1000000L);
            if (n < 0) {
                n = 1000000 + n;
            }
            int n2 = n * 1000;
            LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(l2, n2, ZoneOffset.UTC);
            return localDateTime.format(PARTITION_TIMESTAMP_FORMATTER);
        }
        if (dataType instanceof DecimalType) {
            return ((BigDecimal)object).toString();
        }
        if (dataType instanceof BinaryType) {
            return new String((byte[])object, StandardCharsets.UTF_8);
        }
        throw new UnsupportedOperationException("Unsupported partition column type: " + dataType);
    }

    private static String escapePartitionValue(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '\u0000' && c < CHARS_TO_ESCAPE.size() && CHARS_TO_ESCAPE.get(c)) {
                stringBuilder.append('%');
                stringBuilder.append(String.format("%02X", c));
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    static {
        char[] cArray;
        PARTITION_TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS");
        CHARS_TO_ESCAPE = new BitSet(128);
        for (char c : cArray = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\"', '#', '%', '\'', '*', '/', ':', '=', '?', '\\', '\u007f', '{', '[', ']', '^'}) {
            CHARS_TO_ESCAPE.set(c);
        }
    }
}

