/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.util;

import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.types.StructField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class SchemaChanges {
    private List<StructField> addedFields;
    private List<StructField> removedFields;
    private List<Tuple2<StructField, StructField>> updatedFields;

    private SchemaChanges(List<StructField> list, List<StructField> list2, List<Tuple2<StructField, StructField>> list3) {
        this.addedFields = Collections.unmodifiableList(list);
        this.removedFields = Collections.unmodifiableList(list2);
        this.updatedFields = Collections.unmodifiableList(list3);
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<StructField> addedFields() {
        return this.addedFields;
    }

    public List<StructField> removedFields() {
        return this.removedFields;
    }

    public List<Tuple2<StructField, StructField>> updatedFields() {
        return this.updatedFields;
    }

    static class Builder {
        private List<StructField> addedFields = new ArrayList<StructField>();
        private List<StructField> removedFields = new ArrayList<StructField>();
        private List<Tuple2<StructField, StructField>> updatedFields = new ArrayList<Tuple2<StructField, StructField>>();

        Builder() {
        }

        public Builder withAddedField(StructField structField) {
            this.addedFields.add(structField);
            return this;
        }

        public Builder withRemovedField(StructField structField) {
            this.removedFields.add(structField);
            return this;
        }

        public Builder withUpdatedField(StructField structField, StructField structField2) {
            this.updatedFields.add(new Tuple2<StructField, StructField>(structField, structField2));
            return this;
        }

        public SchemaChanges build() {
            return new SchemaChanges(this.addedFields, this.removedFields, this.updatedFields);
        }
    }
}

