/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.util;

import io.delta.kernel.exceptions.KernelException;
import io.delta.kernel.internal.util.JsonUtils;
import io.delta.kernel.shaded.com.fasterxml.jackson.databind.JsonNode;
import io.delta.kernel.statistics.DataFileStatistics;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;

public class StatsUtils {
    private StatsUtils() {
    }

    public static Optional<DataFileStatistics> deserializeFromJson(String string) {
        JsonNode jsonNode;
        try {
            jsonNode = JsonUtils.mapper().readTree(string);
        }
        catch (IOException iOException) {
            throw new KernelException(String.format("Failed to parse JSON string: %s", string), iOException);
        }
        JsonNode jsonNode2 = jsonNode.get("numRecords");
        if (jsonNode2 == null || !jsonNode2.isNumber()) {
            return Optional.empty();
        }
        long l = jsonNode2.asLong();
        return Optional.of(new DataFileStatistics(l, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap()));
    }
}

