/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.util;

import io.delta.kernel.annotation.Evolving;
import io.delta.kernel.data.FilteredColumnarBatch;
import io.delta.kernel.data.Row;
import io.delta.kernel.utils.CloseableIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

@Evolving
public class Utils {
    public static <T> CloseableIterator<T> singletonCloseableIterator(final T t) {
        return new CloseableIterator<T>(){
            private boolean accessed;

            @Override
            public void close() throws IOException {
            }

            @Override
            public boolean hasNext() {
                return !this.accessed;
            }

            @Override
            public T next() {
                this.accessed = true;
                return t;
            }
        };
    }

    public static <T> CloseableIterator<T> toCloseableIterator(final Iterator<T> iterator) {
        return new CloseableIterator<T>(){

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }
        };
    }

    public static void closeCloseables(AutoCloseable ... autoCloseableArray) {
        Throwable throwable = null;
        for (AutoCloseable autoCloseable : autoCloseableArray) {
            if (autoCloseable == null) continue;
            try {
                autoCloseable.close();
            }
            catch (Exception exception) {
                if (throwable == null) {
                    throwable = new RuntimeException(exception);
                    continue;
                }
                throwable.addSuppressed(exception);
            }
        }
        if (throwable != null) {
            throw throwable;
        }
    }

    public static void closeCloseablesSilently(AutoCloseable ... autoCloseableArray) {
        try {
            Utils.closeCloseables(autoCloseableArray);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static CloseableIterator<Row> intoRows(CloseableIterator<FilteredColumnarBatch> closeableIterator) {
        return new FilteredBatchToRowIter(closeableIterator);
    }

    private static class FilteredBatchToRowIter
    implements CloseableIterator<Row> {
        private final CloseableIterator<FilteredColumnarBatch> sourceBatches;
        private CloseableIterator<Row> current;
        private boolean isClosed = false;

        FilteredBatchToRowIter(CloseableIterator<FilteredColumnarBatch> closeableIterator) {
            this.sourceBatches = closeableIterator;
        }

        @Override
        public boolean hasNext() {
            if (this.isClosed) {
                return false;
            }
            while ((this.current == null || !this.current.hasNext()) && this.sourceBatches.hasNext()) {
                Utils.closeCloseables(this.current);
                FilteredColumnarBatch filteredColumnarBatch = this.sourceBatches.next();
                this.current = filteredColumnarBatch.getRows();
            }
            return this.current != null && this.current.hasNext();
        }

        @Override
        public Row next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more rows available");
            }
            return this.current.next();
        }

        @Override
        public void close() throws IOException {
            this.isClosed = true;
            Utils.closeCloseables(this.current, this.sourceBatches);
        }
    }
}

