/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.statistics;

import io.delta.kernel.expressions.Column;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.util.JsonUtils;
import io.delta.kernel.shaded.com.fasterxml.jackson.core.JsonGenerator;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.types.TimestampNTZType;
import io.delta.kernel.types.TimestampType;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class DataFileStatistics {
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX");
    public static final int MICROSECONDS_PER_SECOND = 1000000;
    public static final int NANOSECONDS_PER_MICROSECOND = 1000;
    private final long numRecords;
    private final Map<Column, Literal> minValues;
    private final Map<Column, Literal> maxValues;
    private final Map<Column, Long> nullCount;

    public DataFileStatistics(long l, Map<Column, Literal> map, Map<Column, Literal> map2, Map<Column, Long> map3) {
        Objects.requireNonNull(map, "minValues must not be null to serialize stats.");
        Objects.requireNonNull(map2, "maxValues must not be null to serialize stats.");
        Objects.requireNonNull(map3, "nullCount must not be null to serialize stats.");
        this.numRecords = l;
        this.minValues = Collections.unmodifiableMap(map);
        this.maxValues = Collections.unmodifiableMap(map2);
        this.nullCount = Collections.unmodifiableMap(map3);
    }

    public long getNumRecords() {
        return this.numRecords;
    }

    public Map<Column, Literal> getMinValues() {
        return this.minValues;
    }

    public Map<Column, Literal> getMaxValues() {
        return this.maxValues;
    }

    public Map<Column, Long> getNullCount() {
        return this.nullCount;
    }

    public String serializeAsJson(StructType structType) {
        return JsonUtils.generate(jsonGenerator2 -> {
            jsonGenerator2.writeStartObject();
            jsonGenerator2.writeNumberField("numRecords", this.numRecords);
            if (structType != null) {
                jsonGenerator2.writeObjectFieldStart("minValues");
                this.writeJsonValues(jsonGenerator2, structType, this.minValues, new Column(new String[0]), (jsonGenerator, literal) -> this.writeJsonValue(jsonGenerator, (Literal)literal));
                jsonGenerator2.writeEndObject();
                jsonGenerator2.writeObjectFieldStart("maxValues");
                this.writeJsonValues(jsonGenerator2, structType, this.maxValues, new Column(new String[0]), (jsonGenerator, literal) -> this.writeJsonValue(jsonGenerator, (Literal)literal));
                jsonGenerator2.writeEndObject();
                jsonGenerator2.writeObjectFieldStart("nullCount");
                this.writeJsonValues(jsonGenerator2, structType, this.nullCount, new Column(new String[0]), (jsonGenerator, l) -> jsonGenerator.writeNumber((long)l));
                jsonGenerator2.writeEndObject();
            }
            jsonGenerator2.writeEndObject();
        });
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DataFileStatistics)) {
            return false;
        }
        DataFileStatistics dataFileStatistics = (DataFileStatistics)object;
        return this.numRecords == dataFileStatistics.numRecords && Objects.equals(this.minValues, dataFileStatistics.minValues) && Objects.equals(this.maxValues, dataFileStatistics.maxValues) && Objects.equals(this.nullCount, dataFileStatistics.nullCount);
    }

    public int hashCode() {
        int n = Long.hashCode(this.numRecords);
        n = 31 * n + Objects.hash(this.minValues.keySet());
        n = 31 * n + Objects.hash(this.maxValues.keySet());
        n = 31 * n + Objects.hash(this.nullCount.keySet());
        return n;
    }

    public String toString() {
        return String.format("DataFileStatistics(numRecords=%s, minValues=%s, maxValues=%s, nullCount=%s)", this.numRecords, this.minValues, this.maxValues, this.nullCount);
    }

    private <T> void writeJsonValues(JsonGenerator jsonGenerator, StructType structType, Map<Column, T> map, Column column, JsonUtils.JsonValueWriter<T> jsonValueWriter) throws IOException {
        if (structType == null) {
            return;
        }
        for (StructField structField : structType.fields()) {
            Column column2 = column.appendNestedField(structField.getName());
            if (structField.getDataType() instanceof StructType) {
                jsonGenerator.writeObjectFieldStart(structField.getName());
                this.writeJsonValues(jsonGenerator, (StructType)structField.getDataType(), map, column2, jsonValueWriter);
                jsonGenerator.writeEndObject();
                continue;
            }
            T t = map.get(column2);
            if (t == null) continue;
            if (t instanceof Literal) {
                this.validateLiteralType(structField, (Literal)t);
            }
            jsonGenerator.writeFieldName(structField.getName());
            jsonValueWriter.write(jsonGenerator, t);
        }
    }

    private void validateLiteralType(StructField structField, Literal literal) {
        if (literal.getDataType() == null || !literal.getDataType().equals(structField.getDataType())) {
            throw DeltaErrors.statsTypeMismatch(structField.getName(), structField.getDataType(), literal.getDataType());
        }
    }

    private void writeJsonValue(JsonGenerator jsonGenerator, Literal literal) throws IOException {
        if (literal == null || literal.getValue() == null) {
            jsonGenerator.writeNull();
            return;
        }
        DataType dataType = literal.getDataType();
        Object object = literal.getValue();
        if (dataType instanceof BooleanType) {
            jsonGenerator.writeBoolean((Boolean)object);
        } else if (dataType instanceof ByteType) {
            jsonGenerator.writeNumber(((Number)object).byteValue());
        } else if (dataType instanceof ShortType) {
            jsonGenerator.writeNumber(((Number)object).shortValue());
        } else if (dataType instanceof IntegerType) {
            jsonGenerator.writeNumber(((Number)object).intValue());
        } else if (dataType instanceof LongType) {
            jsonGenerator.writeNumber(((Number)object).longValue());
        } else if (dataType instanceof FloatType) {
            float f = ((Number)object).floatValue();
            if (Float.isNaN(f) || Float.isInfinite(f)) {
                jsonGenerator.writeString(String.valueOf(f));
            } else {
                jsonGenerator.writeNumber(f);
            }
        } else if (dataType instanceof DoubleType) {
            double d = ((Number)object).doubleValue();
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                jsonGenerator.writeString(String.valueOf(d));
            } else {
                jsonGenerator.writeNumber(d);
            }
        } else if (dataType instanceof StringType) {
            jsonGenerator.writeString((String)object);
        } else if (dataType instanceof BinaryType) {
            jsonGenerator.writeString(new String((byte[])object, StandardCharsets.UTF_8));
        } else if (dataType instanceof DecimalType) {
            jsonGenerator.writeNumber((BigDecimal)object);
        } else if (dataType instanceof DateType) {
            jsonGenerator.writeString(LocalDate.ofEpochDay(((Number)object).longValue()).format(DateTimeFormatter.ISO_LOCAL_DATE));
        } else if (dataType instanceof TimestampType || dataType instanceof TimestampNTZType) {
            long l = (Long)object;
            long l2 = l / 1000000L;
            int n = (int)(l % 1000000L) * 1000;
            if (n < 0) {
                n += 1000000000;
            }
            Instant instant = Instant.ofEpochSecond(l2, n);
            jsonGenerator.writeString(TIMESTAMP_FORMATTER.format(ZonedDateTime.ofInstant(instant.truncatedTo(ChronoUnit.MILLIS), ZoneOffset.UTC)));
        } else {
            throw DeltaErrors.unsupportedStatsDataType(dataType);
        }
    }
}

