/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.actions;

import io.delta.kernel.data.Row;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.internal.actions.DeletionVectorDescriptor;
import io.delta.kernel.internal.data.GenericRow;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.util.InternalUtils;
import io.delta.kernel.internal.util.PartitionUtils;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.DataFileStatus;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class AddFile {
    private static final StructField JSON_STATS_FIELD = new StructField("stats", StringType.STRING, true);
    public static final StructType SCHEMA_WITHOUT_STATS = new StructType().add("path", (DataType)StringType.STRING, false).add("partitionValues", (DataType)new MapType(StringType.STRING, StringType.STRING, true), false).add("size", (DataType)LongType.LONG, false).add("modificationTime", (DataType)LongType.LONG, false).add("dataChange", (DataType)BooleanType.BOOLEAN, false).add("deletionVector", (DataType)DeletionVectorDescriptor.READ_SCHEMA, true).add("tags", (DataType)new MapType(StringType.STRING, StringType.STRING, true), true);
    public static final StructType SCHEMA_WITH_STATS;
    public static final StructType FULL_SCHEMA;
    private static final Map<String, Integer> COL_NAME_TO_ORDINAL;

    public static Row convertDataFileStatus(URI uRI, DataFileStatus dataFileStatus, Map<String, Literal> map, boolean bl) {
        Path path = new Path(dataFileStatus.getPath());
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(COL_NAME_TO_ORDINAL.get("path"), InternalUtils.relativizePath(path, uRI).toString());
        hashMap.put(COL_NAME_TO_ORDINAL.get("partitionValues"), PartitionUtils.serializePartitionMap(map));
        hashMap.put(COL_NAME_TO_ORDINAL.get("size"), dataFileStatus.getSize());
        hashMap.put(COL_NAME_TO_ORDINAL.get("modificationTime"), dataFileStatus.getModificationTime());
        hashMap.put(COL_NAME_TO_ORDINAL.get("dataChange"), bl);
        if (dataFileStatus.getStatistics().isPresent()) {
            hashMap.put(COL_NAME_TO_ORDINAL.get("stats"), dataFileStatus.getStatistics().get().serializeAsJson());
        }
        return new GenericRow(FULL_SCHEMA, hashMap);
    }

    static {
        FULL_SCHEMA = SCHEMA_WITH_STATS = SCHEMA_WITHOUT_STATS.add(JSON_STATS_FIELD);
        COL_NAME_TO_ORDINAL = IntStream.range(0, FULL_SCHEMA.length()).boxed().collect(Collectors.toMap(n -> FULL_SCHEMA.at((int)n).getName(), n -> n));
    }
}

