/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.replay;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.exceptions.ConcurrentWriteException;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.SnapshotImpl;
import io.delta.kernel.internal.TransactionImpl;
import io.delta.kernel.internal.actions.SetTransaction;
import io.delta.kernel.internal.actions.SingleAction;
import io.delta.kernel.internal.replay.ActionsIterator;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ConflictChecker {
    private static final int PROTOCOL_ORDINAL = SingleAction.CONFLICT_RESOLUTION_SCHEMA.indexOf("protocol");
    private static final int METADATA_ORDINAL = SingleAction.CONFLICT_RESOLUTION_SCHEMA.indexOf("metaData");
    private static final int TXN_ORDINAL = SingleAction.CONFLICT_RESOLUTION_SCHEMA.indexOf("txn");
    private final SnapshotImpl snapshot;
    private final TransactionImpl transaction;
    private final long attemptVersion;

    private ConflictChecker(SnapshotImpl snapshotImpl, TransactionImpl transactionImpl, long l) {
        this.snapshot = snapshotImpl;
        this.transaction = transactionImpl;
        this.attemptVersion = l;
    }

    public static TransactionRebaseState resolveConflicts(Engine engine, SnapshotImpl snapshotImpl, long l, TransactionImpl transactionImpl) throws ConcurrentWriteException {
        Preconditions.checkArgument(transactionImpl.isBlindAppend(), "Current support is for blind appends only.");
        return new ConflictChecker(snapshotImpl, transactionImpl, l).resolveConflicts(engine);
    }

    public TransactionRebaseState resolveConflicts(Engine engine) throws ConcurrentWriteException {
        List<FileStatus> list = this.getWinningCommitFiles(engine);
        Preconditions.checkState(!list.isEmpty(), "No winning commits found.");
        try (ActionsIterator actionsIterator = new ActionsIterator(engine, list, SingleAction.CONFLICT_RESOLUTION_SCHEMA, Optional.empty());){
            actionsIterator.forEachRemaining(actionWrapper -> {
                Preconditions.checkArgument(!actionWrapper.isFromCheckpoint());
                ColumnarBatch columnarBatch = actionWrapper.getColumnarBatch();
                this.handleProtocol(columnarBatch.getColumnVector(PROTOCOL_ORDINAL));
                this.handleMetadata(columnarBatch.getColumnVector(METADATA_ORDINAL));
                this.handleTxn(columnarBatch.getColumnVector(TXN_ORDINAL));
            });
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Error reading actions from winning commits.", iOException);
        }
        return new TransactionRebaseState(this.getLastWinningTxnVersion(list));
    }

    private void handleProtocol(ColumnVector columnVector) {
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i)) continue;
            throw DeltaErrors.protocolChangedException(this.attemptVersion);
        }
    }

    private void handleMetadata(ColumnVector columnVector) {
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i)) continue;
            throw DeltaErrors.metadataChangedException();
        }
    }

    private void handleTxn(ColumnVector columnVector) {
        Optional<SetTransaction> optional = this.transaction.getSetTxnOpt();
        optional.ifPresent(setTransaction -> {
            for (int i = 0; i < columnVector.getSize(); ++i) {
                SetTransaction setTransaction2 = SetTransaction.fromColumnVector(columnVector, i);
                if (setTransaction2 == null || !setTransaction2.getAppId().equals(setTransaction.getAppId()) || setTransaction2.getVersion() < setTransaction.getVersion()) continue;
                throw DeltaErrors.concurrentTransaction(setTransaction.getAppId(), setTransaction.getVersion(), setTransaction2.getVersion());
            }
        });
    }

    private List<FileStatus> getWinningCommitFiles(Engine engine) {
        Object object;
        block10: {
            String string = FileNames.deltaFile(this.snapshot.getLogPath(), this.snapshot.getVersion(engine) + 1L);
            CloseableIterator<FileStatus> closeableIterator = engine.getFileSystemClient().listFrom(string);
            try {
                ArrayList<FileStatus> arrayList = new ArrayList<FileStatus>();
                while (closeableIterator.hasNext()) {
                    object = closeableIterator.next();
                    if (!FileNames.isCommitFile(((FileStatus)object).getPath())) continue;
                    arrayList.add((FileStatus)object);
                }
                object = ConflictChecker.ensureNoGapsInWinningCommits(arrayList);
                if (closeableIterator == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (closeableIterator != null) {
                        try {
                            closeableIterator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new IllegalStateException("No winning commits found.", fileNotFoundException);
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException("Error listing files from " + string, iOException);
                }
            }
            closeableIterator.close();
        }
        return object;
    }

    private long getLastWinningTxnVersion(List<FileStatus> list) {
        FileStatus fileStatus = list.get(list.size() - 1);
        return FileNames.deltaVersion(fileStatus.getPath());
    }

    private static List<FileStatus> ensureNoGapsInWinningCommits(List<FileStatus> list) {
        long l = -1L;
        for (FileStatus fileStatus : list) {
            long l2 = FileNames.deltaVersion(fileStatus.getPath());
            Preconditions.checkState(l == -1L || l2 == l + 1L, String.format("Gaps in Delta log commit files. Expected version %d but got %d", l + 1L, l2));
            l = l2;
        }
        return list;
    }

    public static class TransactionRebaseState {
        private final long latestVersion;

        public TransactionRebaseState(long l) {
            this.latestVersion = l;
        }

        public long getLatestVersion() {
            return this.latestVersion;
        }
    }
}

