/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.replay;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.FilteredColumnarBatch;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.internal.TableFeatures;
import io.delta.kernel.internal.actions.AddFile;
import io.delta.kernel.internal.actions.DeletionVectorDescriptor;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.actions.SetTransaction;
import io.delta.kernel.internal.checkpoints.SidecarFile;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.replay.ActionWrapper;
import io.delta.kernel.internal.replay.ActionsIterator;
import io.delta.kernel.internal.replay.ActiveAddFilesIterator;
import io.delta.kernel.internal.replay.LogReplayUtils;
import io.delta.kernel.internal.snapshot.LogSegment;
import io.delta.kernel.internal.snapshot.SnapshotHint;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import java.io.IOException;
import java.util.Optional;

public class LogReplay {
    public static final StructType PROTOCOL_METADATA_READ_SCHEMA = new StructType().add("protocol", Protocol.FULL_SCHEMA).add("metaData", Metadata.FULL_SCHEMA);
    private static StructType REMOVE_FILE_SCHEMA = new StructType().add("path", (DataType)StringType.STRING, false).add("deletionVector", (DataType)DeletionVectorDescriptor.READ_SCHEMA, true);
    public static final StructType SET_TRANSACTION_READ_SCHEMA = new StructType().add("txn", SetTransaction.FULL_SCHEMA);
    public static String SIDECAR_FIELD_NAME = "sidecar";
    public static String ADDFILE_FIELD_NAME = "add";
    public static String REMOVEFILE_FIELD_NAME = "remove";
    public static int ADD_FILE_ORDINAL = 0;
    public static int ADD_FILE_PATH_ORDINAL = AddFile.SCHEMA_WITHOUT_STATS.indexOf("path");
    public static int ADD_FILE_DV_ORDINAL = AddFile.SCHEMA_WITHOUT_STATS.indexOf("deletionVector");
    public static int REMOVE_FILE_ORDINAL = 1;
    public static int REMOVE_FILE_PATH_ORDINAL = REMOVE_FILE_SCHEMA.indexOf("path");
    public static int REMOVE_FILE_DV_ORDINAL = REMOVE_FILE_SCHEMA.indexOf("deletionVector");
    private final Path dataPath;
    private final LogSegment logSegment;
    private final Tuple2<Protocol, Metadata> protocolAndMetadata;

    private static StructType getAddSchema(boolean bl) {
        return bl ? AddFile.SCHEMA_WITH_STATS : AddFile.SCHEMA_WITHOUT_STATS;
    }

    public static StructType withSidecarFileSchema(StructType structType) {
        return structType.add(SIDECAR_FIELD_NAME, SidecarFile.READ_SCHEMA);
    }

    public static boolean containsAddOrRemoveFileActions(StructType structType) {
        return structType.fieldNames().contains(ADDFILE_FIELD_NAME) || structType.fieldNames().contains(REMOVEFILE_FIELD_NAME);
    }

    public static StructType getAddRemoveReadSchema(boolean bl) {
        return new StructType().add(ADDFILE_FIELD_NAME, LogReplay.getAddSchema(bl)).add(REMOVEFILE_FIELD_NAME, REMOVE_FILE_SCHEMA);
    }

    public LogReplay(Path path, Path path2, long l, Engine engine, LogSegment logSegment, Optional<SnapshotHint> optional) {
        LogReplayUtils.assertLogFilesBelongToTable(path, logSegment.allLogFilesUnsorted());
        this.dataPath = path2;
        this.logSegment = logSegment;
        this.protocolAndMetadata = this.loadTableProtocolAndMetadata(engine, optional, l);
    }

    public Protocol getProtocol() {
        return (Protocol)this.protocolAndMetadata._1;
    }

    public Metadata getMetadata() {
        return (Metadata)this.protocolAndMetadata._2;
    }

    public Optional<Long> getLatestTransactionIdentifier(Engine engine, String string) {
        return this.loadLatestTransactionVersion(engine, string);
    }

    public CloseableIterator<FilteredColumnarBatch> getAddFilesAsColumnarBatches(Engine engine, boolean bl, Optional<Predicate> optional) {
        ActionsIterator actionsIterator = new ActionsIterator(engine, this.logSegment.allLogFilesReversed(), LogReplay.getAddRemoveReadSchema(bl), optional);
        return new ActiveAddFilesIterator(engine, actionsIterator, this.dataPath);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected Tuple2<Protocol, Metadata> loadTableProtocolAndMetadata(Engine engine, Optional<SnapshotHint> optional, long l) {
        if (optional.isPresent() && optional.get().getVersion() == l) {
            return new Tuple2<Protocol, Metadata>(optional.get().getProtocol(), optional.get().getMetadata());
        }
        Protocol protocol = null;
        Metadata metadata = null;
        try (ActionsIterator actionsIterator = new ActionsIterator(engine, this.logSegment.allLogFilesReversed(), PROTOCOL_METADATA_READ_SCHEMA, Optional.empty());){
            while (actionsIterator.hasNext()) {
                int n;
                Object object;
                ActionWrapper actionWrapper = (ActionWrapper)actionsIterator.next();
                long l2 = actionWrapper.getVersion();
                ColumnarBatch columnarBatch = null;
                if (protocol == null) {
                    columnarBatch = actionWrapper.getColumnarBatch();
                    assert (columnarBatch.getSchema().equals(PROTOCOL_METADATA_READ_SCHEMA));
                    object = columnarBatch.getColumnVector(0);
                    for (n = 0; n < object.getSize(); ++n) {
                        if (object.isNullAt(n)) continue;
                        protocol = Protocol.fromColumnVector((ColumnVector)object, n);
                        if (metadata == null) break;
                        Tuple2<Protocol, Metadata> tuple2 = new Tuple2<Protocol, Metadata>(protocol, metadata);
                        return tuple2;
                    }
                }
                if (metadata == null) {
                    if (columnarBatch == null) {
                        columnarBatch = actionWrapper.getColumnarBatch();
                        assert (columnarBatch.getSchema().equals(PROTOCOL_METADATA_READ_SCHEMA));
                    }
                    object = columnarBatch.getColumnVector(1);
                    for (n = 0; n < object.getSize(); ++n) {
                        if (object.isNullAt(n)) continue;
                        metadata = Metadata.fromColumnVector((ColumnVector)object, n, engine);
                        if (protocol == null) break;
                        TableFeatures.validateReadSupportedTable(protocol, metadata, this.dataPath.toString());
                        Tuple2<Protocol, Metadata> tuple2 = new Tuple2<Protocol, Metadata>(protocol, metadata);
                        return tuple2;
                    }
                }
                if (!optional.isPresent() || l2 != optional.get().getVersion() + 1L) continue;
                if (protocol == null) {
                    protocol = optional.get().getProtocol();
                }
                if (metadata == null) {
                    metadata = optional.get().getMetadata();
                }
                object = new Tuple2<Protocol, Metadata>(protocol, metadata);
                return object;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not close iterator", iOException);
        }
        if (protocol == null) {
            throw new IllegalStateException(String.format("No protocol found at version %s", this.logSegment.version));
        }
        throw new IllegalStateException(String.format("No metadata found at version %s", this.logSegment.version));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<Long> loadLatestTransactionVersion(Engine engine, String string) {
        try (ActionsIterator actionsIterator = new ActionsIterator(engine, this.logSegment.allLogFilesReversed(), SET_TRANSACTION_READ_SCHEMA, Optional.empty());){
            block8: while (true) {
                if (!actionsIterator.hasNext()) return Optional.empty();
                ColumnarBatch columnarBatch = ((ActionWrapper)actionsIterator.next()).getColumnarBatch();
                assert (columnarBatch.getSchema().equals(SET_TRANSACTION_READ_SCHEMA));
                ColumnVector columnVector = columnarBatch.getColumnVector(0);
                int n = 0;
                while (true) {
                    SetTransaction setTransaction;
                    if (n >= columnVector.getSize()) continue block8;
                    if (!columnVector.isNullAt(n) && (setTransaction = SetTransaction.fromColumnVector(columnVector, n)) != null && string.equals(setTransaction.getAppId())) {
                        Optional<Long> optional = Optional.of(setTransaction.getVersion());
                        return optional;
                    }
                    ++n;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to fetch the transaction identifier", iOException);
        }
    }
}

