/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.delta.kernel.client.FileReadContext;
import io.delta.kernel.client.JsonHandler;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.FileDataReadResult;
import io.delta.kernel.data.Row;
import io.delta.kernel.defaults.client.DefaultFileHandler;
import io.delta.kernel.defaults.internal.DefaultKernelUtils;
import io.delta.kernel.defaults.internal.data.DefaultJsonRow;
import io.delta.kernel.defaults.internal.data.DefaultRowBasedColumnarBatch;
import io.delta.kernel.internal.InternalScanFileUtils;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class DefaultJsonHandler
extends DefaultFileHandler
implements JsonHandler {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Configuration hadoopConf;
    private final int maxBatchSize;

    public DefaultJsonHandler(Configuration configuration) {
        this.hadoopConf = configuration;
        this.maxBatchSize = configuration.getInt("delta.kernel.default.json.reader.batch-size", 1024);
        DefaultKernelUtils.checkArgument(this.maxBatchSize > 0, "invalid JSON reader batch size: " + this.maxBatchSize);
    }

    public ColumnarBatch parseJson(ColumnVector columnVector, StructType structType) {
        ArrayList<Row> arrayList = new ArrayList<Row>();
        for (int i = 0; i < columnVector.getSize(); ++i) {
            arrayList.add(this.parseJson(columnVector.getString(i), structType));
        }
        return new DefaultRowBasedColumnarBatch(structType, arrayList);
    }

    public CloseableIterator<FileDataReadResult> readJsonFiles(final CloseableIterator<FileReadContext> closeableIterator, final StructType structType) throws IOException {
        return new CloseableIterator<FileDataReadResult>(){
            private FileReadContext currentFile;
            private BufferedReader currentFileReader;
            private String nextLine;

            public void close() throws IOException {
                Utils.closeCloseables((AutoCloseable[])new AutoCloseable[]{this.currentFileReader, closeableIterator});
            }

            public boolean hasNext() {
                if (this.nextLine != null) {
                    return true;
                }
                try {
                    if (this.currentFileReader == null || (this.nextLine = this.currentFileReader.readLine()) == null) {
                        this.tryOpenNextFile();
                        if (this.currentFileReader != null) {
                            this.nextLine = this.currentFileReader.readLine();
                        }
                    }
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                return this.nextLine != null;
            }

            public FileDataReadResult next() {
                if (this.nextLine == null) {
                    throw new NoSuchElementException();
                }
                ArrayList<Row> arrayList = new ArrayList<Row>();
                int n = 0;
                do {
                    arrayList.add(DefaultJsonHandler.this.parseJson(this.nextLine, structType));
                    this.nextLine = null;
                } while (++n < DefaultJsonHandler.this.maxBatchSize && this.hasNext());
                final DefaultRowBasedColumnarBatch defaultRowBasedColumnarBatch = new DefaultRowBasedColumnarBatch(structType, arrayList);
                final Row row = this.currentFile.getScanFileRow();
                return new FileDataReadResult(){

                    public ColumnarBatch getData() {
                        return defaultRowBasedColumnarBatch;
                    }

                    public Row getScanFileRow() {
                        return row;
                    }
                };
            }

            private void tryOpenNextFile() throws IOException {
                Utils.closeCloseables((AutoCloseable[])new AutoCloseable[]{this.currentFileReader});
                this.currentFileReader = null;
                if (closeableIterator.hasNext()) {
                    this.currentFile = (FileReadContext)closeableIterator.next();
                    FileStatus fileStatus = InternalScanFileUtils.getAddFileStatus((Row)this.currentFile.getScanFileRow());
                    Path path = new Path(fileStatus.getPath());
                    FileSystem fileSystem = path.getFileSystem(DefaultJsonHandler.this.hadoopConf);
                    FSDataInputStream fSDataInputStream = null;
                    try {
                        fSDataInputStream = fileSystem.open(path);
                        this.currentFileReader = new BufferedReader(new InputStreamReader((InputStream)fSDataInputStream, StandardCharsets.UTF_8));
                    }
                    catch (Exception exception) {
                        Utils.closeCloseablesSilently((AutoCloseable[])new AutoCloseable[]{fSDataInputStream});
                        throw exception;
                    }
                }
            }
        };
    }

    private Row parseJson(String string, StructType structType) {
        try {
            JsonNode jsonNode = this.objectMapper.readTree(string);
            return new DefaultJsonRow((ObjectNode)jsonNode, structType);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new RuntimeException(String.format("Could not parse JSON: %s", string), jsonProcessingException);
        }
    }
}

