/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.client;

import io.delta.kernel.client.FileReadContext;
import io.delta.kernel.client.ParquetHandler;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.FileDataReadResult;
import io.delta.kernel.data.Row;
import io.delta.kernel.defaults.client.DefaultFileHandler;
import io.delta.kernel.defaults.internal.parquet.ParquetBatchReader;
import io.delta.kernel.internal.InternalScanFileUtils;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;

public class DefaultParquetHandler
extends DefaultFileHandler
implements ParquetHandler {
    private final Configuration hadoopConf;

    public DefaultParquetHandler(Configuration configuration) {
        this.hadoopConf = configuration;
    }

    public CloseableIterator<FileDataReadResult> readParquetFiles(final CloseableIterator<FileReadContext> closeableIterator, final StructType structType) throws IOException {
        return new CloseableIterator<FileDataReadResult>(){
            private final ParquetBatchReader batchReader;
            private FileReadContext currentFile;
            private CloseableIterator<ColumnarBatch> currentFileReader;
            {
                this.batchReader = new ParquetBatchReader(DefaultParquetHandler.this.hadoopConf);
            }

            public void close() throws IOException {
                Utils.closeCloseables((AutoCloseable[])new AutoCloseable[]{this.currentFileReader, closeableIterator});
            }

            public boolean hasNext() {
                if (this.currentFileReader == null || !this.currentFileReader.hasNext()) {
                    Utils.closeCloseables((AutoCloseable[])new AutoCloseable[]{this.currentFileReader});
                    this.currentFileReader = null;
                    if (closeableIterator.hasNext()) {
                        this.currentFile = (FileReadContext)closeableIterator.next();
                        FileStatus fileStatus = InternalScanFileUtils.getAddFileStatus((Row)this.currentFile.getScanFileRow());
                        this.currentFileReader = this.batchReader.read(fileStatus.getPath(), structType);
                    } else {
                        return false;
                    }
                }
                return this.currentFileReader.hasNext();
            }

            public FileDataReadResult next() {
                final ColumnarBatch columnarBatch = (ColumnarBatch)this.currentFileReader.next();
                return new FileDataReadResult(){

                    public ColumnarBatch getData() {
                        return columnarBatch;
                    }

                    public Row getScanFileRow() {
                        return currentFile.getScanFileRow();
                    }
                };
            }
        };
    }
}

