/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal;

import io.delta.kernel.types.DataType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

public class DefaultKernelUtils {
    private static final LocalDate EPOCH = LocalDate.ofEpochDay(0L);
    static int JULIAN_DAY_OF_EPOCH = 2440588;

    private DefaultKernelUtils() {
    }

    public static final MessageType pruneSchema(GroupType groupType, StructType structType) {
        return new MessageType("fileSchema", DefaultKernelUtils.pruneFields(groupType, structType));
    }

    public static Type findSubFieldType(GroupType groupType, StructField structField) {
        String string = structField.getName();
        if (groupType.containsField(string)) {
            return groupType.getType(string);
        }
        for (Type type : groupType.getFields()) {
            if (!type.getName().equalsIgnoreCase(string)) continue;
            return type;
        }
        return null;
    }

    public static void checkArgument(boolean bl) throws IllegalArgumentException {
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean bl, String string) throws IllegalArgumentException {
        if (!bl) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void checkArgument(boolean bl, String string, Object ... objectArray) throws IllegalArgumentException {
        if (!bl) {
            throw new IllegalArgumentException(String.format(String.valueOf(string), objectArray));
        }
    }

    private static List<Type> pruneFields(GroupType groupType, StructType structType) {
        return structType.fields().stream().map(structField -> {
            Type type = DefaultKernelUtils.findSubFieldType(groupType, structField);
            if (type != null) {
                return DefaultKernelUtils.prunedType(type, structField.getDataType());
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Type prunedType(Type type, DataType dataType) {
        if (type instanceof GroupType && dataType instanceof StructType) {
            GroupType groupType = (GroupType)type;
            StructType structType = (StructType)dataType;
            return groupType.withNewFields(DefaultKernelUtils.pruneFields(groupType, structType));
        }
        return type;
    }

    public static long fromJulianDay(int n, long l) {
        return (long)(n - JULIAN_DAY_OF_EPOCH) * 86400000000L + l / 1000L;
    }

    public static long millisToMicros(long l) {
        return Math.multiplyExact(l, 1000L);
    }

    public static class DateTimeConstants {
        public static final int MONTHS_PER_YEAR = 12;
        public static final byte DAYS_PER_WEEK = 7;
        public static final long HOURS_PER_DAY = 24L;
        public static final long MINUTES_PER_HOUR = 60L;
        public static final long SECONDS_PER_MINUTE = 60L;
        public static final long SECONDS_PER_HOUR = 3600L;
        public static final long SECONDS_PER_DAY = 86400L;
        public static final long MILLIS_PER_SECOND = 1000L;
        public static final long MILLIS_PER_MINUTE = 60000L;
        public static final long MILLIS_PER_HOUR = 3600000L;
        public static final long MILLIS_PER_DAY = 86400000L;
        public static final long MICROS_PER_MILLIS = 1000L;
        public static final long MICROS_PER_SECOND = 1000000L;
        public static final long MICROS_PER_MINUTE = 60000000L;
        public static final long MICROS_PER_HOUR = 3600000000L;
        public static final long MICROS_PER_DAY = 86400000000L;
        public static final long NANOS_PER_MICROS = 1000L;
        public static final long NANOS_PER_MILLIS = 1000000L;
        public static final long NANOS_PER_SECOND = 1000000000L;
    }
}

