/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.data;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.delta.kernel.data.ArrayValue;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.MapValue;
import io.delta.kernel.data.Row;
import io.delta.kernel.defaults.internal.data.vector.DefaultGenericVector;
import io.delta.kernel.internal.types.MixedDataType;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class DefaultJsonRow
implements Row {
    private final Object[] parsedValues;
    private final StructType readSchema;

    public DefaultJsonRow(ObjectNode objectNode, StructType structType) {
        this.readSchema = structType;
        this.parsedValues = new Object[structType.length()];
        for (int i = 0; i < structType.length(); ++i) {
            Object object;
            StructField structField = structType.at(i);
            this.parsedValues[i] = object = DefaultJsonRow.decodeField(objectNode, structField);
        }
    }

    public StructType getSchema() {
        return this.readSchema;
    }

    public boolean isNullAt(int n) {
        return this.parsedValues[n] == null;
    }

    public boolean getBoolean(int n) {
        return (Boolean)this.parsedValues[n];
    }

    public byte getByte(int n) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public short getShort(int n) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public int getInt(int n) {
        return (Integer)this.parsedValues[n];
    }

    public long getLong(int n) {
        return (Long)this.parsedValues[n];
    }

    public float getFloat(int n) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public double getDouble(int n) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String getString(int n) {
        return (String)this.parsedValues[n];
    }

    public BigDecimal getDecimal(int n) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public byte[] getBinary(int n) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Row getStruct(int n) {
        return (DefaultJsonRow)this.parsedValues[n];
    }

    public ArrayValue getArray(int n) {
        return (ArrayValue)this.parsedValues[n];
    }

    public MapValue getMap(int n) {
        return (MapValue)this.parsedValues[n];
    }

    private static void throwIfTypeMismatch(String string, boolean bl, JsonNode jsonNode) {
        if (!bl) {
            throw new RuntimeException(String.format("Couldn't decode %s, expected a %s", jsonNode, string));
        }
    }

    private static Object decodeElement(final JsonNode jsonNode, DataType dataType) {
        if (jsonNode.isNull()) {
            return null;
        }
        if (dataType.equals((Object)MixedDataType.INSTANCE)) {
            if (jsonNode.isTextual()) {
                return jsonNode.textValue();
            }
            if (jsonNode instanceof ObjectNode) {
                return jsonNode.toString();
            }
            DefaultJsonRow.throwIfTypeMismatch("object or string", false, jsonNode);
        }
        if (dataType instanceof BooleanType) {
            DefaultJsonRow.throwIfTypeMismatch("boolean", jsonNode.isBoolean(), jsonNode);
            return jsonNode.booleanValue();
        }
        if (dataType instanceof IntegerType) {
            DefaultJsonRow.throwIfTypeMismatch("integer", jsonNode.isIntegralNumber() && !jsonNode.isLong(), jsonNode);
            return jsonNode.intValue();
        }
        if (dataType instanceof LongType) {
            DefaultJsonRow.throwIfTypeMismatch("long", jsonNode.isIntegralNumber(), jsonNode);
            return jsonNode.numberValue().longValue();
        }
        if (dataType instanceof StringType) {
            DefaultJsonRow.throwIfTypeMismatch("string", jsonNode.isTextual() | jsonNode.isIntegralNumber(), jsonNode);
            return jsonNode.asText();
        }
        if (dataType instanceof StructType) {
            DefaultJsonRow.throwIfTypeMismatch("object", jsonNode.isObject(), jsonNode);
            return new DefaultJsonRow((ObjectNode)jsonNode, (StructType)dataType);
        }
        if (dataType instanceof ArrayType) {
            DefaultJsonRow.throwIfTypeMismatch("array", jsonNode.isArray(), jsonNode);
            final ArrayType arrayType = (ArrayType)dataType;
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            final Object[] objectArray = new Object[arrayNode.size()];
            for (int i = 0; i < arrayNode.size(); ++i) {
                JsonNode jsonNode2 = arrayNode.get(i);
                Object object = DefaultJsonRow.decodeElement(jsonNode2, arrayType.getElementType());
                if (object == null && !arrayType.containsNull()) {
                    throw new RuntimeException("Array type expects no nulls as elements, but received `null` as array element");
                }
                objectArray[i] = object;
            }
            return new ArrayValue(){

                public int getSize() {
                    return objectArray.length;
                }

                public ColumnVector getElements() {
                    return DefaultGenericVector.fromArray(arrayType.getElementType(), objectArray);
                }
            };
        }
        if (dataType instanceof MapType) {
            DefaultJsonRow.throwIfTypeMismatch("map", jsonNode.isObject(), jsonNode);
            final MapType mapType = (MapType)dataType;
            if (!(mapType.getKeyType() instanceof StringType)) {
                throw new RuntimeException("MapType with a key type of `String` is supported, received a key type: " + mapType.getKeyType());
            }
            final ArrayList<String> arrayList = new ArrayList<String>(jsonNode.size());
            final ArrayList<Object> arrayList2 = new ArrayList<Object>(jsonNode.size());
            Iterator iterator = jsonNode.fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String string = (String)entry.getKey();
                Object object = DefaultJsonRow.decodeElement((JsonNode)entry.getValue(), mapType.getValueType());
                if (object == null && !mapType.isValueContainsNull()) {
                    throw new RuntimeException("Map type expects no nulls in values, but received `null` as value");
                }
                arrayList.add(string);
                arrayList2.add(object);
            }
            return new MapValue(){

                public int getSize() {
                    return jsonNode.size();
                }

                public ColumnVector getKeys() {
                    return DefaultGenericVector.fromList(mapType.getKeyType(), arrayList);
                }

                public ColumnVector getValues() {
                    return DefaultGenericVector.fromList(mapType.getValueType(), arrayList2);
                }
            };
        }
        throw new UnsupportedOperationException(String.format("Unsupported DataType %s for RootNode %s", dataType, jsonNode));
    }

    private static Object decodeField(ObjectNode objectNode, StructField structField) {
        if (objectNode.get(structField.getName()) == null || objectNode.get(structField.getName()).isNull()) {
            if (structField.isNullable()) {
                return null;
            }
            throw new RuntimeException(String.format("Root node at key %s is null but field isn't nullable. Root node: %s", structField.getName(), objectNode));
        }
        return DefaultJsonRow.decodeElement(objectNode.get(structField.getName()), structField.getDataType());
    }
}

