/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.data.vector;

import io.delta.kernel.data.ArrayValue;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.defaults.internal.DefaultKernelUtils;
import io.delta.kernel.defaults.internal.data.vector.AbstractColumnVector;
import io.delta.kernel.defaults.internal.data.vector.DefaultViewVector;
import io.delta.kernel.types.DataType;
import java.util.Objects;
import java.util.Optional;

public class DefaultArrayVector
extends AbstractColumnVector {
    private final int[] offsets;
    private final ColumnVector elementVector;

    public DefaultArrayVector(int n, DataType dataType, Optional<boolean[]> optional, int[] nArray, ColumnVector columnVector) {
        super(n, dataType, optional);
        DefaultKernelUtils.checkArgument(nArray.length >= n + 1, "invalid offset array size");
        this.offsets = Objects.requireNonNull(nArray, "offsets is null");
        this.elementVector = Objects.requireNonNull(columnVector, "elementVector is null");
    }

    @Override
    public ArrayValue getArray(int n) {
        this.checkValidRowId(n);
        if (this.isNullAt(n)) {
            return null;
        }
        final int n2 = this.offsets[n];
        final int n3 = this.offsets[n + 1];
        return new ArrayValue(){
            private final ColumnVector elements;
            {
                this.elements = new DefaultViewVector(DefaultArrayVector.this.elementVector, n2, n3);
            }

            public int getSize() {
                return this.elements.getSize();
            }

            public ColumnVector getElements() {
                return this.elements;
            }
        };
    }
}

