/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.data.vector;

import io.delta.kernel.defaults.internal.DefaultKernelUtils;
import io.delta.kernel.defaults.internal.data.vector.AbstractColumnVector;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import java.util.Objects;
import java.util.Optional;

public class DefaultByteVector
extends AbstractColumnVector {
    private final byte[] values;

    public DefaultByteVector(int n, Optional<boolean[]> optional, byte[] byArray) {
        super(n, (DataType)ByteType.BYTE, optional);
        this.values = Objects.requireNonNull(byArray, "values is null");
        DefaultKernelUtils.checkArgument(byArray.length >= n, "invalid number of values (%s) for given size (%s)", byArray.length, n);
    }

    @Override
    public byte getByte(int n) {
        this.checkValidRowId(n);
        return this.values[n];
    }
}

