/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.data.vector;

import io.delta.kernel.defaults.internal.DefaultKernelUtils;
import io.delta.kernel.defaults.internal.data.vector.AbstractColumnVector;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DoubleType;
import java.util.Objects;
import java.util.Optional;

public class DefaultDoubleVector
extends AbstractColumnVector {
    private final double[] values;

    public DefaultDoubleVector(int n, Optional<boolean[]> optional, double[] dArray) {
        super(n, (DataType)DoubleType.DOUBLE, optional);
        this.values = Objects.requireNonNull(dArray, "values is null");
        DefaultKernelUtils.checkArgument(dArray.length >= n, "invalid number of values (%s) for given size (%s)", dArray.length, n);
    }

    @Override
    public double getDouble(int n) {
        this.checkValidRowId(n);
        return this.values[n];
    }
}

