/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.data.vector;

import io.delta.kernel.defaults.internal.DefaultKernelUtils;
import io.delta.kernel.defaults.internal.data.vector.AbstractColumnVector;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.FloatType;
import java.util.Objects;
import java.util.Optional;

public class DefaultFloatVector
extends AbstractColumnVector {
    private final float[] values;

    public DefaultFloatVector(int n, Optional<boolean[]> optional, float[] fArray) {
        super(n, (DataType)FloatType.FLOAT, optional);
        this.values = Objects.requireNonNull(fArray, "values is null");
        DefaultKernelUtils.checkArgument(fArray.length >= n, "invalid number of values (%s) for given size (%s)", fArray.length, n);
    }

    @Override
    public float getFloat(int n) {
        this.checkValidRowId(n);
        return this.values[n];
    }
}

