/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.data.vector;

import io.delta.kernel.defaults.internal.DefaultKernelUtils;
import io.delta.kernel.defaults.internal.data.vector.AbstractColumnVector;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.IntegerType;
import java.util.Objects;
import java.util.Optional;

public class DefaultIntVector
extends AbstractColumnVector {
    private final int[] values;

    public DefaultIntVector(DataType dataType, int n, Optional<boolean[]> optional, int[] nArray) {
        super(n, dataType, optional);
        DefaultKernelUtils.checkArgument(dataType instanceof IntegerType || dataType instanceof DateType);
        this.values = Objects.requireNonNull(nArray, "values is null");
        DefaultKernelUtils.checkArgument(nArray.length >= n, "invalid number of values (%s) for given size (%s)", nArray.length, n);
    }

    @Override
    public int getInt(int n) {
        this.checkValidRowId(n);
        return this.values[n];
    }
}

