/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.data.vector;

import io.delta.kernel.defaults.internal.DefaultKernelUtils;
import io.delta.kernel.defaults.internal.data.vector.AbstractColumnVector;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.TimestampType;
import java.util.Objects;
import java.util.Optional;

public class DefaultLongVector
extends AbstractColumnVector {
    private final long[] values;

    public DefaultLongVector(DataType dataType, int n, Optional<boolean[]> optional, long[] lArray) {
        super(n, dataType, optional);
        DefaultKernelUtils.checkArgument(dataType instanceof LongType || dataType instanceof TimestampType);
        this.values = Objects.requireNonNull(lArray, "values is null");
        DefaultKernelUtils.checkArgument(lArray.length >= n, "invalid number of values (%s) for given size (%s)", lArray.length, n);
    }

    @Override
    public long getLong(int n) {
        this.checkValidRowId(n);
        return this.values[n];
    }
}

