/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.data.vector;

import io.delta.kernel.defaults.internal.DefaultKernelUtils;
import io.delta.kernel.defaults.internal.data.vector.AbstractColumnVector;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.ShortType;
import java.util.Objects;
import java.util.Optional;

public class DefaultShortVector
extends AbstractColumnVector {
    private final short[] values;

    public DefaultShortVector(int n, Optional<boolean[]> optional, short[] sArray) {
        super(n, (DataType)ShortType.SHORT, optional);
        this.values = Objects.requireNonNull(sArray, "values is null");
        DefaultKernelUtils.checkArgument(sArray.length >= n, "invalid number of values (%s) for given size (%s)", sArray.length, n);
    }

    @Override
    public short getShort(int n) {
        this.checkValidRowId(n);
        return this.values[n];
    }
}

