/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.data.vector;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.defaults.internal.DefaultKernelUtils;
import io.delta.kernel.defaults.internal.data.vector.AbstractColumnVector;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.StructType;
import java.util.Optional;

public class DefaultStructVector
extends AbstractColumnVector {
    private final ColumnVector[] memberVectors;

    public DefaultStructVector(int n, DataType dataType, Optional<boolean[]> optional, ColumnVector[] columnVectorArray) {
        super(n, dataType, optional);
        DefaultKernelUtils.checkArgument(dataType instanceof StructType, "not a struct type");
        StructType structType = (StructType)dataType;
        DefaultKernelUtils.checkArgument(structType.length() == columnVectorArray.length, "expected a one column vector for each member");
        this.memberVectors = columnVectorArray;
    }

    public ColumnVector getChild(int n) {
        DefaultKernelUtils.checkArgument(n >= 0 && n < this.memberVectors.length, "Invalid ordinal " + n);
        return this.memberVectors[n];
    }
}

