/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.data.vector;

import io.delta.kernel.data.ArrayValue;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.MapValue;
import io.delta.kernel.data.Row;
import io.delta.kernel.defaults.internal.DefaultKernelUtils;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.function.Function;

public class DefaultSubFieldVector
implements ColumnVector {
    private final int size;
    private final DataType dataType;
    private final int columnOrdinal;
    private final Function<Integer, Row> rowIdToRowAccessor;

    public DefaultSubFieldVector(int n, DataType dataType, int n2, Function<Integer, Row> function) {
        DefaultKernelUtils.checkArgument(n >= 0, "invalid size: %s", n);
        this.size = n;
        DefaultKernelUtils.checkArgument(n2 >= 0, "invalid column ordinal: %s", n2);
        this.columnOrdinal = n2;
        this.rowIdToRowAccessor = Objects.requireNonNull(function, "rowIdToRowAccessor is null");
        this.dataType = Objects.requireNonNull(dataType, "dataType is null");
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public int getSize() {
        return this.size;
    }

    public void close() {
    }

    public boolean isNullAt(int n) {
        this.assertValidRowId(n);
        Row row = this.rowIdToRowAccessor.apply(n);
        return row == null || row.isNullAt(this.columnOrdinal);
    }

    public boolean getBoolean(int n) {
        this.assertValidRowId(n);
        return this.rowIdToRowAccessor.apply(n).getBoolean(this.columnOrdinal);
    }

    public byte getByte(int n) {
        this.assertValidRowId(n);
        return this.rowIdToRowAccessor.apply(n).getByte(this.columnOrdinal);
    }

    public short getShort(int n) {
        this.assertValidRowId(n);
        return this.rowIdToRowAccessor.apply(n).getShort(this.columnOrdinal);
    }

    public int getInt(int n) {
        this.assertValidRowId(n);
        return this.rowIdToRowAccessor.apply(n).getInt(this.columnOrdinal);
    }

    public long getLong(int n) {
        this.assertValidRowId(n);
        return this.rowIdToRowAccessor.apply(n).getLong(this.columnOrdinal);
    }

    public float getFloat(int n) {
        this.assertValidRowId(n);
        return this.rowIdToRowAccessor.apply(n).getFloat(this.columnOrdinal);
    }

    public double getDouble(int n) {
        this.assertValidRowId(n);
        return this.rowIdToRowAccessor.apply(n).getDouble(this.columnOrdinal);
    }

    public byte[] getBinary(int n) {
        this.assertValidRowId(n);
        return this.rowIdToRowAccessor.apply(n).getBinary(this.columnOrdinal);
    }

    public String getString(int n) {
        this.assertValidRowId(n);
        return this.rowIdToRowAccessor.apply(n).getString(this.columnOrdinal);
    }

    public BigDecimal getDecimal(int n) {
        this.assertValidRowId(n);
        return this.rowIdToRowAccessor.apply(n).getDecimal(this.columnOrdinal);
    }

    public MapValue getMap(int n) {
        this.assertValidRowId(n);
        return this.rowIdToRowAccessor.apply(n).getMap(this.columnOrdinal);
    }

    public ArrayValue getArray(int n) {
        this.assertValidRowId(n);
        return this.rowIdToRowAccessor.apply(n).getArray(this.columnOrdinal);
    }

    public ColumnVector getChild(int n2) {
        StructType structType = (StructType)this.dataType;
        StructField structField = structType.at(n2);
        return new DefaultSubFieldVector(this.size, structField.getDataType(), n2, n -> this.rowIdToRowAccessor.apply((Integer)n).getStruct(this.columnOrdinal));
    }

    private void assertValidRowId(int n) {
        DefaultKernelUtils.checkArgument(n < this.size, "Invalid rowId: " + n + ", max allowed rowId is: " + (this.size - 1));
    }
}

