/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.expressions;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.defaults.internal.DefaultKernelUtils;
import io.delta.kernel.defaults.internal.data.vector.DefaultBooleanVector;
import io.delta.kernel.defaults.internal.data.vector.DefaultConstantVector;
import io.delta.kernel.defaults.internal.expressions.ElementAtEvaluator;
import io.delta.kernel.defaults.internal.expressions.ExpressionUtils;
import io.delta.kernel.defaults.internal.expressions.ExpressionVisitor;
import io.delta.kernel.defaults.internal.expressions.ImplicitCastExpression;
import io.delta.kernel.defaults.internal.expressions.PartitionValueEvaluator;
import io.delta.kernel.expressions.AlwaysFalse;
import io.delta.kernel.expressions.AlwaysTrue;
import io.delta.kernel.expressions.And;
import io.delta.kernel.expressions.Column;
import io.delta.kernel.expressions.Expression;
import io.delta.kernel.expressions.ExpressionEvaluator;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.expressions.Or;
import io.delta.kernel.expressions.PartitionValueExpression;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.expressions.ScalarExpression;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import io.delta.kernel.types.TimestampType;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public class DefaultExpressionEvaluator
implements ExpressionEvaluator {
    private final Expression expression;

    public DefaultExpressionEvaluator(StructType structType, Expression expression, DataType dataType) {
        ExpressionTransformResult expressionTransformResult = (ExpressionTransformResult)new ExpressionTransformer(structType).visit(expression);
        if (!expressionTransformResult.outputType.equivalent(dataType)) {
            throw new UnsupportedOperationException(String.format("Can not create an expression handler for expression `%s` returns result of type %s", expression, dataType));
        }
        this.expression = expressionTransformResult.expression;
    }

    public ColumnVector eval(ColumnarBatch columnarBatch) {
        return (ColumnVector)new ExpressionEvalVisitor(columnarBatch).visit(this.expression);
    }

    public void close() {
    }

    private static void assertColumnExists(boolean bl, StructType structType, Column column) {
        if (!bl) {
            throw new IllegalArgumentException(String.format("%s doesn't exist in input data schema: %s", column, structType));
        }
    }

    private static class PredicateChildrenEvalResult {
        public final int rowCount;
        public final ColumnVector leftResult;
        public final ColumnVector rightResult;

        PredicateChildrenEvalResult(int n, ColumnVector columnVector, ColumnVector columnVector2) {
            this.rowCount = n;
            this.leftResult = columnVector;
            this.rightResult = columnVector2;
        }
    }

    private static class ExpressionEvalVisitor
    extends ExpressionVisitor<ColumnVector> {
        private final ColumnarBatch input;

        ExpressionEvalVisitor(ColumnarBatch columnarBatch) {
            this.input = columnarBatch;
        }

        @Override
        ColumnVector visitAnd(And and) {
            PredicateChildrenEvalResult predicateChildrenEvalResult = this.evalBinaryExpressionChildren((Predicate)and);
            int n = predicateChildrenEvalResult.rowCount;
            boolean[] blArray = new boolean[n];
            boolean[] blArray2 = ExpressionUtils.evalNullability(predicateChildrenEvalResult.leftResult, predicateChildrenEvalResult.rightResult);
            for (int i = 0; i < n; ++i) {
                blArray[i] = predicateChildrenEvalResult.leftResult.getBoolean(i) && predicateChildrenEvalResult.rightResult.getBoolean(i);
            }
            return new DefaultBooleanVector(n, Optional.of(blArray2), blArray);
        }

        @Override
        ColumnVector visitOr(Or or) {
            PredicateChildrenEvalResult predicateChildrenEvalResult = this.evalBinaryExpressionChildren((Predicate)or);
            int n = predicateChildrenEvalResult.rowCount;
            boolean[] blArray = new boolean[n];
            boolean[] blArray2 = ExpressionUtils.evalNullability(predicateChildrenEvalResult.leftResult, predicateChildrenEvalResult.rightResult);
            for (int i = 0; i < n; ++i) {
                blArray[i] = predicateChildrenEvalResult.leftResult.getBoolean(i) || predicateChildrenEvalResult.rightResult.getBoolean(i);
            }
            return new DefaultBooleanVector(n, Optional.of(blArray2), blArray);
        }

        @Override
        ColumnVector visitAlwaysTrue(AlwaysTrue alwaysTrue) {
            return new DefaultConstantVector((DataType)BooleanType.BOOLEAN, this.input.getSize(), true);
        }

        @Override
        ColumnVector visitAlwaysFalse(AlwaysFalse alwaysFalse) {
            return new DefaultConstantVector((DataType)BooleanType.BOOLEAN, this.input.getSize(), false);
        }

        @Override
        ColumnVector visitComparator(Predicate predicate) {
            PredicateChildrenEvalResult predicateChildrenEvalResult = this.evalBinaryExpressionChildren(predicate);
            int n = predicateChildrenEvalResult.rowCount;
            boolean[] blArray = new boolean[n];
            boolean[] blArray2 = ExpressionUtils.evalNullability(predicateChildrenEvalResult.leftResult, predicateChildrenEvalResult.rightResult);
            int[] nArray = ExpressionUtils.compare(predicateChildrenEvalResult.leftResult, predicateChildrenEvalResult.rightResult);
            switch (predicate.getName()) {
                case "=": {
                    for (int i = 0; i < n; ++i) {
                        blArray[i] = nArray[i] == 0;
                    }
                    break;
                }
                case ">": {
                    for (int i = 0; i < n; ++i) {
                        blArray[i] = nArray[i] > 0;
                    }
                    break;
                }
                case ">=": {
                    for (int i = 0; i < n; ++i) {
                        blArray[i] = nArray[i] >= 0;
                    }
                    break;
                }
                case "<": {
                    for (int i = 0; i < n; ++i) {
                        blArray[i] = nArray[i] < 0;
                    }
                    break;
                }
                case "<=": {
                    for (int i = 0; i < n; ++i) {
                        blArray[i] = nArray[i] <= 0;
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unsupported expression encountered: " + predicate);
                }
            }
            return new DefaultBooleanVector(n, Optional.of(blArray2), blArray);
        }

        @Override
        ColumnVector visitLiteral(Literal literal) {
            DataType dataType = literal.getDataType();
            if (dataType instanceof BooleanType || dataType instanceof ByteType || dataType instanceof ShortType || dataType instanceof IntegerType || dataType instanceof LongType || dataType instanceof FloatType || dataType instanceof DoubleType || dataType instanceof StringType || dataType instanceof BinaryType || dataType instanceof DecimalType || dataType instanceof DateType || dataType instanceof TimestampType) {
                return new DefaultConstantVector(dataType, this.input.getSize(), literal.getValue());
            }
            throw new UnsupportedOperationException("unsupported expression encountered: " + literal);
        }

        @Override
        ColumnVector visitColumn(Column column) {
            String[] stringArray = column.getNames();
            StructType structType = this.input.getSchema();
            ColumnVector columnVector = null;
            for (int i = 0; i < stringArray.length; ++i) {
                DefaultExpressionEvaluator.assertColumnExists(structType instanceof StructType, this.input.getSchema(), column);
                StructType structType2 = structType;
                int n = structType2.indexOf(stringArray[i]);
                DefaultExpressionEvaluator.assertColumnExists(n != -1, this.input.getSchema(), column);
                structType = structType2.at(n).getDataType();
                columnVector = i == 0 ? this.input.getColumnVector(n) : columnVector.getChild(n);
            }
            DefaultExpressionEvaluator.assertColumnExists(columnVector != null, this.input.getSchema(), column);
            return columnVector;
        }

        @Override
        ColumnVector visitCast(ImplicitCastExpression implicitCastExpression) {
            ColumnVector columnVector = (ColumnVector)this.visit(implicitCastExpression.getInput());
            return implicitCastExpression.eval(columnVector);
        }

        @Override
        ColumnVector visitPartitionValue(PartitionValueExpression partitionValueExpression) {
            ColumnVector columnVector = (ColumnVector)this.visit(partitionValueExpression.getInput());
            return PartitionValueEvaluator.eval(columnVector, partitionValueExpression.getDataType());
        }

        @Override
        ColumnVector visitElementAt(ScalarExpression scalarExpression) {
            ColumnVector columnVector = (ColumnVector)this.visit(ExpressionUtils.childAt((Expression)scalarExpression, 0));
            ColumnVector columnVector2 = (ColumnVector)this.visit(ExpressionUtils.childAt((Expression)scalarExpression, 1));
            return ElementAtEvaluator.eval(columnVector, columnVector2);
        }

        private PredicateChildrenEvalResult evalBinaryExpressionChildren(Predicate predicate) {
            ColumnVector columnVector = (ColumnVector)this.visit(ExpressionUtils.getLeft((Expression)predicate));
            ColumnVector columnVector2 = (ColumnVector)this.visit(ExpressionUtils.getRight((Expression)predicate));
            DefaultKernelUtils.checkArgument(columnVector.getSize() == columnVector2.getSize(), "Left and right operand returned different results: left=%d, right=d", columnVector.getSize(), columnVector2.getSize());
            return new PredicateChildrenEvalResult(columnVector.getSize(), columnVector, columnVector2);
        }
    }

    private static class ExpressionTransformer
    extends ExpressionVisitor<ExpressionTransformResult> {
        private StructType inputDataSchema;

        ExpressionTransformer(StructType structType) {
            this.inputDataSchema = Objects.requireNonNull(structType, "inputDataSchema is null");
        }

        @Override
        ExpressionTransformResult visitAnd(And and) {
            Predicate predicate = this.validateIsPredicate((Expression)and, (ExpressionTransformResult)this.visit((Expression)and.getLeft()));
            Predicate predicate2 = this.validateIsPredicate((Expression)and, (ExpressionTransformResult)this.visit((Expression)and.getRight()));
            return new ExpressionTransformResult((Expression)new And(predicate, predicate2), (DataType)BooleanType.BOOLEAN);
        }

        @Override
        ExpressionTransformResult visitOr(Or or) {
            Predicate predicate = this.validateIsPredicate((Expression)or, (ExpressionTransformResult)this.visit((Expression)or.getLeft()));
            Predicate predicate2 = this.validateIsPredicate((Expression)or, (ExpressionTransformResult)this.visit((Expression)or.getRight()));
            return new ExpressionTransformResult((Expression)new Or(predicate, predicate2), (DataType)BooleanType.BOOLEAN);
        }

        @Override
        ExpressionTransformResult visitAlwaysTrue(AlwaysTrue alwaysTrue) {
            return new ExpressionTransformResult((Expression)alwaysTrue, (DataType)BooleanType.BOOLEAN);
        }

        @Override
        ExpressionTransformResult visitAlwaysFalse(AlwaysFalse alwaysFalse) {
            return new ExpressionTransformResult((Expression)alwaysFalse, (DataType)BooleanType.BOOLEAN);
        }

        @Override
        ExpressionTransformResult visitComparator(Predicate predicate) {
            switch (predicate.getName()) {
                case "=": 
                case ">": 
                case ">=": 
                case "<": 
                case "<=": {
                    return new ExpressionTransformResult(this.transformBinaryComparator(predicate), (DataType)BooleanType.BOOLEAN);
                }
            }
            throw new UnsupportedOperationException("unsupported expression encountered: " + predicate);
        }

        @Override
        ExpressionTransformResult visitLiteral(Literal literal) {
            return new ExpressionTransformResult((Expression)literal, literal.getDataType());
        }

        @Override
        ExpressionTransformResult visitColumn(Column column) {
            String[] stringArray = column.getNames();
            StructType structType = this.inputDataSchema;
            for (int i = 0; i < stringArray.length; ++i) {
                DefaultExpressionEvaluator.assertColumnExists(structType instanceof StructType, this.inputDataSchema, column);
                StructType structType2 = structType;
                int n = structType2.indexOf(stringArray[i]);
                DefaultExpressionEvaluator.assertColumnExists(n != -1, this.inputDataSchema, column);
                structType = structType2.at(n).getDataType();
            }
            DefaultExpressionEvaluator.assertColumnExists(structType != null, this.inputDataSchema, column);
            return new ExpressionTransformResult((Expression)column, (DataType)structType);
        }

        @Override
        ExpressionTransformResult visitCast(ImplicitCastExpression implicitCastExpression) {
            throw new UnsupportedOperationException("CAST expression is not expected.");
        }

        @Override
        ExpressionTransformResult visitPartitionValue(PartitionValueExpression partitionValueExpression) {
            ExpressionTransformResult expressionTransformResult = (ExpressionTransformResult)this.visit(partitionValueExpression.getInput());
            DefaultKernelUtils.checkArgument(expressionTransformResult.outputType instanceof StringType, "%s: expected string input, but got %s", partitionValueExpression, expressionTransformResult.outputType);
            DataType dataType = partitionValueExpression.getDataType();
            if (dataType instanceof StructType || dataType instanceof ArrayType || dataType instanceof MapType) {
                throw new UnsupportedOperationException("unsupported partition data type: " + dataType);
            }
            return new ExpressionTransformResult((Expression)new PartitionValueExpression(expressionTransformResult.expression, dataType), dataType);
        }

        @Override
        ExpressionTransformResult visitElementAt(ScalarExpression scalarExpression) {
            ExpressionTransformResult expressionTransformResult = (ExpressionTransformResult)this.visit(ExpressionUtils.childAt((Expression)scalarExpression, 0));
            ExpressionTransformResult expressionTransformResult2 = (ExpressionTransformResult)this.visit(ExpressionUtils.childAt((Expression)scalarExpression, 1));
            ScalarExpression scalarExpression2 = ElementAtEvaluator.validateAndTransform(scalarExpression, expressionTransformResult.expression, expressionTransformResult.outputType, expressionTransformResult2.expression, expressionTransformResult2.outputType);
            return new ExpressionTransformResult((Expression)scalarExpression2, ((MapType)expressionTransformResult.outputType).getValueType());
        }

        private Predicate validateIsPredicate(Expression expression, ExpressionTransformResult expressionTransformResult) {
            DefaultKernelUtils.checkArgument(expressionTransformResult.outputType instanceof BooleanType && expressionTransformResult.expression instanceof Predicate, "%s: expected a predicate expression but got %s with output type %s.", expression, expressionTransformResult.expression, expressionTransformResult.outputType);
            return (Predicate)expressionTransformResult.expression;
        }

        private Expression transformBinaryComparator(Predicate predicate) {
            ExpressionTransformResult expressionTransformResult = (ExpressionTransformResult)this.visit(ExpressionUtils.getLeft((Expression)predicate));
            ExpressionTransformResult expressionTransformResult2 = (ExpressionTransformResult)this.visit(ExpressionUtils.getRight((Expression)predicate));
            Expression expression = expressionTransformResult.expression;
            Expression expression2 = expressionTransformResult2.expression;
            if (!expressionTransformResult.outputType.equivalent(expressionTransformResult2.outputType)) {
                if (ImplicitCastExpression.canCastTo(expressionTransformResult.outputType, expressionTransformResult2.outputType)) {
                    expression = new ImplicitCastExpression(expression, expressionTransformResult2.outputType);
                } else if (ImplicitCastExpression.canCastTo(expressionTransformResult2.outputType, expressionTransformResult.outputType)) {
                    expression2 = new ImplicitCastExpression(expression2, expressionTransformResult.outputType);
                } else {
                    String string = String.format("%s: operands are of different types which are not comparable: left type=%s, right type=%s", predicate, expressionTransformResult.outputType, expressionTransformResult2.outputType);
                    throw new UnsupportedOperationException(string);
                }
            }
            return new Predicate(predicate.getName(), Arrays.asList(expression, expression2));
        }
    }

    private static class ExpressionTransformResult {
        public final Expression expression;
        public final DataType outputType;

        ExpressionTransformResult(Expression expression, DataType dataType) {
            this.expression = expression;
            this.outputType = dataType;
        }
    }
}

