/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.expressions;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.defaults.internal.DefaultKernelUtils;
import io.delta.kernel.expressions.Expression;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.TimestampType;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;

class ExpressionUtils {
    private ExpressionUtils() {
    }

    static boolean[] evalNullability(ColumnVector columnVector, ColumnVector columnVector2) {
        int n = columnVector.getSize();
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = columnVector.isNullAt(i) || columnVector2.isNullAt(i);
        }
        return blArray;
    }

    static int[] compare(ColumnVector columnVector, ColumnVector columnVector2) {
        DefaultKernelUtils.checkArgument(columnVector.getSize() == columnVector2.getSize(), "Left and right operand have different vector sizes.");
        DataType dataType = columnVector.getDataType();
        int n = columnVector.getSize();
        int[] nArray = new int[n];
        if (dataType instanceof BooleanType) {
            ExpressionUtils.compareBoolean(columnVector, columnVector2, nArray);
        } else if (dataType instanceof ByteType) {
            ExpressionUtils.compareByte(columnVector, columnVector2, nArray);
        } else if (dataType instanceof ShortType) {
            ExpressionUtils.compareShort(columnVector, columnVector2, nArray);
        } else if (dataType instanceof IntegerType || dataType instanceof DateType) {
            ExpressionUtils.compareInt(columnVector, columnVector2, nArray);
        } else if (dataType instanceof LongType || dataType instanceof TimestampType) {
            ExpressionUtils.compareLong(columnVector, columnVector2, nArray);
        } else if (dataType instanceof FloatType) {
            ExpressionUtils.compareFloat(columnVector, columnVector2, nArray);
        } else if (dataType instanceof DoubleType) {
            ExpressionUtils.compareDouble(columnVector, columnVector2, nArray);
        } else if (dataType instanceof DecimalType) {
            ExpressionUtils.compareDecimal(columnVector, columnVector2, nArray);
        } else if (dataType instanceof StringType) {
            ExpressionUtils.compareString(columnVector, columnVector2, nArray);
        } else if (dataType instanceof BinaryType) {
            ExpressionUtils.compareBinary(columnVector, columnVector2, nArray);
        } else {
            throw new UnsupportedOperationException(dataType + " can not be compared.");
        }
        return nArray;
    }

    static void compareBoolean(ColumnVector columnVector, ColumnVector columnVector2, int[] nArray) {
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i) || columnVector2.isNullAt(i)) continue;
            nArray[i] = Boolean.compare(columnVector.getBoolean(i), columnVector2.getBoolean(i));
        }
    }

    static void compareByte(ColumnVector columnVector, ColumnVector columnVector2, int[] nArray) {
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i) || columnVector2.isNullAt(i)) continue;
            nArray[i] = Byte.compare(columnVector.getByte(i), columnVector2.getByte(i));
        }
    }

    static void compareShort(ColumnVector columnVector, ColumnVector columnVector2, int[] nArray) {
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i) || columnVector2.isNullAt(i)) continue;
            nArray[i] = Short.compare(columnVector.getShort(i), columnVector2.getShort(i));
        }
    }

    static void compareInt(ColumnVector columnVector, ColumnVector columnVector2, int[] nArray) {
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i) || columnVector2.isNullAt(i)) continue;
            nArray[i] = Integer.compare(columnVector.getInt(i), columnVector2.getInt(i));
        }
    }

    static void compareLong(ColumnVector columnVector, ColumnVector columnVector2, int[] nArray) {
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i) || columnVector2.isNullAt(i)) continue;
            nArray[i] = Long.compare(columnVector.getLong(i), columnVector2.getLong(i));
        }
    }

    static void compareFloat(ColumnVector columnVector, ColumnVector columnVector2, int[] nArray) {
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i) || columnVector2.isNullAt(i)) continue;
            nArray[i] = Float.compare(columnVector.getFloat(i), columnVector2.getFloat(i));
        }
    }

    static void compareDouble(ColumnVector columnVector, ColumnVector columnVector2, int[] nArray) {
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i) || columnVector2.isNullAt(i)) continue;
            nArray[i] = Double.compare(columnVector.getDouble(i), columnVector2.getDouble(i));
        }
    }

    static void compareString(ColumnVector columnVector, ColumnVector columnVector2, int[] nArray) {
        Comparator<String> comparator = Comparator.naturalOrder();
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i) || columnVector2.isNullAt(i)) continue;
            nArray[i] = comparator.compare(columnVector.getString(i), columnVector2.getString(i));
        }
    }

    static void compareDecimal(ColumnVector columnVector, ColumnVector columnVector2, int[] nArray) {
        Comparator<BigDecimal> comparator = Comparator.naturalOrder();
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i) || columnVector2.isNullAt(i)) continue;
            nArray[i] = comparator.compare(columnVector.getDecimal(i), columnVector2.getDecimal(i));
        }
    }

    static void compareBinary(ColumnVector columnVector, ColumnVector columnVector2, int[] nArray) {
        Comparator comparator = (byArray, byArray2) -> {
            for (int i = 0; i < ((byte[])byArray).length && i < ((byte[])byArray2).length; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                return Byte.compare(byArray[i], byArray2[i]);
            }
            return Integer.compare(((byte[])byArray).length, ((byte[])byArray2).length);
        };
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i) || columnVector2.isNullAt(i)) continue;
            nArray[i] = comparator.compare(columnVector.getBinary(i), columnVector2.getBinary(i));
        }
    }

    static Expression getLeft(Expression expression) {
        List list = expression.getChildren();
        DefaultKernelUtils.checkArgument(list.size() == 2, String.format("%s: expected two inputs, but got %s", expression, list.size()));
        return (Expression)list.get(0);
    }

    static Expression getRight(Expression expression) {
        List list = expression.getChildren();
        DefaultKernelUtils.checkArgument(list.size() == 2, String.format("%s: expected two inputs, but got %s", expression, list.size()));
        return (Expression)list.get(1);
    }

    static Expression childAt(Expression expression, int n) {
        return (Expression)expression.getChildren().get(n);
    }
}

