/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.expressions;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.internal.util.InternalUtils;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import java.math.BigDecimal;
import java.sql.Date;

class PartitionValueEvaluator {
    PartitionValueEvaluator() {
    }

    static ColumnVector eval(final ColumnVector columnVector, final DataType dataType) {
        return new ColumnVector(){

            public DataType getDataType() {
                return dataType;
            }

            public int getSize() {
                return columnVector.getSize();
            }

            public void close() {
                columnVector.close();
            }

            public boolean isNullAt(int n) {
                return columnVector.isNullAt(n);
            }

            public boolean getBoolean(int n) {
                return Boolean.parseBoolean(columnVector.getString(n));
            }

            public byte getByte(int n) {
                return Byte.parseByte(columnVector.getString(n));
            }

            public short getShort(int n) {
                return Short.parseShort(columnVector.getString(n));
            }

            public int getInt(int n) {
                if (dataType.equivalent((DataType)IntegerType.INTEGER)) {
                    return Integer.parseInt(columnVector.getString(n));
                }
                if (dataType.equivalent((DataType)DateType.DATE)) {
                    return InternalUtils.daysSinceEpoch((Date)Date.valueOf(columnVector.getString(n)));
                }
                throw new UnsupportedOperationException("Invalid value request for data type");
            }

            public long getLong(int n) {
                if (dataType.equivalent((DataType)LongType.LONG)) {
                    return Long.parseLong(columnVector.getString(n));
                }
                throw new UnsupportedOperationException("Invalid value request for data type");
            }

            public float getFloat(int n) {
                return Float.parseFloat(columnVector.getString(n));
            }

            public double getDouble(int n) {
                return Double.parseDouble(columnVector.getString(n));
            }

            public byte[] getBinary(int n) {
                return columnVector.isNullAt(n) ? null : columnVector.getString(n).getBytes();
            }

            public String getString(int n) {
                return columnVector.getString(n);
            }

            public BigDecimal getDecimal(int n) {
                return columnVector.isNullAt(n) ? null : new BigDecimal(columnVector.getString(n));
            }
        };
    }
}

