/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.parquet;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.defaults.internal.data.vector.DefaultArrayVector;
import io.delta.kernel.defaults.internal.parquet.ParquetConverters;
import io.delta.kernel.defaults.internal.parquet.RepeatedValueConverter;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.DataType;
import java.util.Optional;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.schema.GroupType;

class ArrayConverter
extends RepeatedValueConverter {
    private final ArrayType typeFromClient;

    ArrayConverter(int n, ArrayType arrayType, GroupType groupType) {
        super(n, ArrayConverter.createElementConverter(n, arrayType, groupType));
        this.typeFromClient = arrayType;
    }

    @Override
    public ColumnVector getDataColumnVector(int n) {
        DefaultArrayVector defaultArrayVector = new DefaultArrayVector(n, (DataType)this.typeFromClient, Optional.of(this.getNullability()), this.getOffsets(), this.getElementDataVectors()[0]);
        this.resetWorkingState();
        return defaultArrayVector;
    }

    private static Converter createElementConverter(int n, ArrayType arrayType, GroupType groupType) {
        GroupType groupType2 = (GroupType)groupType.getType("list");
        return ParquetConverters.createConverter(n, arrayType.getElementType(), groupType2.getType("element"));
    }
}

