/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.client;

import io.delta.kernel.client.ExpressionHandler;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.defaults.internal.data.vector.DefaultBooleanVector;
import io.delta.kernel.defaults.internal.expressions.DefaultExpressionEvaluator;
import io.delta.kernel.defaults.internal.expressions.DefaultPredicateEvaluator;
import io.delta.kernel.expressions.Expression;
import io.delta.kernel.expressions.ExpressionEvaluator;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.expressions.PredicateEvaluator;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.StructType;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public class DefaultExpressionHandler
implements ExpressionHandler {
    public ExpressionEvaluator getEvaluator(StructType structType, Expression expression, DataType dataType) {
        return new DefaultExpressionEvaluator(structType, expression, dataType);
    }

    public PredicateEvaluator getPredicateEvaluator(StructType structType, Predicate predicate) {
        return new DefaultPredicateEvaluator(structType, predicate);
    }

    public ColumnVector createSelectionVector(boolean[] blArray, int n, int n2) {
        Objects.requireNonNull(blArray, "values is null");
        int n3 = n2 - n;
        Preconditions.checkArgument((n3 >= 0 && blArray.length > n && blArray.length >= n2 ? 1 : 0) != 0, (String)String.format("invalid range from=%s, to=%s, values length=%s", n, n2, blArray.length));
        boolean[] blArray2 = Arrays.copyOfRange(blArray, n, n2);
        return new DefaultBooleanVector(n3, Optional.empty(), blArray2);
    }
}

