/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.client;

import io.delta.kernel.client.FileReadRequest;
import io.delta.kernel.client.FileSystemClient;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.utils.CloseableIterator;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class DefaultFileSystemClient
implements FileSystemClient {
    private final Configuration hadoopConf;

    public DefaultFileSystemClient(Configuration configuration) {
        this.hadoopConf = configuration;
    }

    public CloseableIterator<io.delta.kernel.utils.FileStatus> listFrom(String string) throws IOException {
        Path path = new Path(string);
        FileSystem fileSystem = path.getFileSystem(this.hadoopConf);
        if (!fileSystem.exists(path.getParent())) {
            throw new FileNotFoundException(String.format("No such file or directory: %s", path.getParent()));
        }
        FileStatus[] fileStatusArray = fileSystem.listStatus(path.getParent());
        Iterator iterator = Arrays.stream(fileStatusArray).filter(fileStatus -> fileStatus.getPath().getName().compareTo(path.getName()) >= 0).sorted(Comparator.comparing(fileStatus -> fileStatus.getPath().getName())).iterator();
        return Utils.toCloseableIterator(iterator).map(fileStatus -> io.delta.kernel.utils.FileStatus.of((String)fileStatus.getPath().toString(), (long)fileStatus.getLen(), (long)fileStatus.getModificationTime()));
    }

    public String resolvePath(String string) throws IOException {
        Path path = new Path(string);
        FileSystem fileSystem = path.getFileSystem(this.hadoopConf);
        Path path2 = fileSystem.resolvePath(path);
        return fileSystem.makeQualified(path2).toString();
    }

    public CloseableIterator<ByteArrayInputStream> readFiles(CloseableIterator<FileReadRequest> closeableIterator) {
        return closeableIterator.map(fileReadRequest -> this.getStream(fileReadRequest.getPath(), fileReadRequest.getStartOffset(), fileReadRequest.getReadLength()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ByteArrayInputStream getStream(String string, int n, int n2) {
        Path path = new Path(string);
        try {
            FileSystem fileSystem = path.getFileSystem(this.hadoopConf);
            try (FSDataInputStream fSDataInputStream = fileSystem.open(path);){
                fSDataInputStream.skipBytes(n);
                byte[] byArray = new byte[n2];
                fSDataInputStream.readFully(byArray);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                return byteArrayInputStream;
            }
            catch (IOException iOException) {
                throw new RuntimeException(String.format("IOException reading from file %s at offset %s size %s", string, n, n2), iOException);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(String.format("Could not resolve the FileSystem for path %s", string), iOException);
        }
    }
}

