/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.client;

import io.delta.kernel.client.ParquetHandler;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.defaults.internal.parquet.ParquetBatchReader;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;

public class DefaultParquetHandler
implements ParquetHandler {
    private final Configuration hadoopConf;

    public DefaultParquetHandler(Configuration configuration) {
        this.hadoopConf = configuration;
    }

    public CloseableIterator<ColumnarBatch> readParquetFiles(final CloseableIterator<FileStatus> closeableIterator, final StructType structType, Optional<Predicate> optional) throws IOException {
        return new CloseableIterator<ColumnarBatch>(){
            private final ParquetBatchReader batchReader;
            private FileStatus currentFile;
            private CloseableIterator<ColumnarBatch> currentFileReader;
            {
                this.batchReader = new ParquetBatchReader(DefaultParquetHandler.this.hadoopConf);
            }

            public void close() throws IOException {
                Utils.closeCloseables((AutoCloseable[])new AutoCloseable[]{this.currentFileReader, closeableIterator});
            }

            public boolean hasNext() {
                if (this.currentFileReader != null && this.currentFileReader.hasNext()) {
                    return true;
                }
                Utils.closeCloseables((AutoCloseable[])new AutoCloseable[]{this.currentFileReader});
                this.currentFileReader = null;
                if (closeableIterator.hasNext()) {
                    this.currentFile = (FileStatus)closeableIterator.next();
                    this.currentFileReader = this.batchReader.read(this.currentFile.getPath(), structType);
                    return this.hasNext();
                }
                return false;
            }

            public ColumnarBatch next() {
                return (ColumnarBatch)this.currentFileReader.next();
            }
        };
    }
}

