/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal;

import java.time.LocalDate;

public class DefaultKernelUtils {
    private static final LocalDate EPOCH = LocalDate.ofEpochDay(0L);
    static int JULIAN_DAY_OF_EPOCH = 2440588;

    private DefaultKernelUtils() {
    }

    public static long fromJulianDay(int n, long l) {
        return (long)(n - JULIAN_DAY_OF_EPOCH) * 86400000000L + l / 1000L;
    }

    public static long millisToMicros(long l) {
        return Math.multiplyExact(l, 1000L);
    }

    public static class DateTimeConstants {
        public static final int MONTHS_PER_YEAR = 12;
        public static final byte DAYS_PER_WEEK = 7;
        public static final long HOURS_PER_DAY = 24L;
        public static final long MINUTES_PER_HOUR = 60L;
        public static final long SECONDS_PER_MINUTE = 60L;
        public static final long SECONDS_PER_HOUR = 3600L;
        public static final long SECONDS_PER_DAY = 86400L;
        public static final long MILLIS_PER_SECOND = 1000L;
        public static final long MILLIS_PER_MINUTE = 60000L;
        public static final long MILLIS_PER_HOUR = 3600000L;
        public static final long MILLIS_PER_DAY = 86400000L;
        public static final long MICROS_PER_MILLIS = 1000L;
        public static final long MICROS_PER_SECOND = 1000000L;
        public static final long MICROS_PER_MINUTE = 60000000L;
        public static final long MICROS_PER_HOUR = 3600000000L;
        public static final long MICROS_PER_DAY = 86400000000L;
        public static final long NANOS_PER_MICROS = 1000L;
        public static final long NANOS_PER_MILLIS = 1000000L;
        public static final long NANOS_PER_SECOND = 1000000000L;
    }
}

