/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.data.vector;

import io.delta.kernel.defaults.internal.data.vector.AbstractColumnVector;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.TimestampType;
import java.util.Objects;
import java.util.Optional;

public class DefaultLongVector
extends AbstractColumnVector {
    private final long[] values;

    public DefaultLongVector(DataType dataType, int n, Optional<boolean[]> optional, long[] lArray) {
        super(n, dataType, optional);
        Preconditions.checkArgument((dataType instanceof LongType || dataType instanceof TimestampType ? 1 : 0) != 0);
        this.values = Objects.requireNonNull(lArray, "values is null");
        Preconditions.checkArgument((lArray.length >= n ? 1 : 0) != 0, (String)"invalid number of values (%s) for given size (%s)", (Object[])new Object[]{lArray.length, n});
    }

    @Override
    public long getLong(int n) {
        this.checkValidRowId(n);
        return this.values[n];
    }
}

