/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.parquet;

import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.defaults.internal.parquet.ParquetSchemaUtils;
import io.delta.kernel.defaults.internal.parquet.RowConverter;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;

public class ParquetBatchReader {
    private final Configuration configuration;
    private final int maxBatchSize;

    public ParquetBatchReader(Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration, "configuration is null");
        this.maxBatchSize = configuration.getInt("delta.kernel.default.parquet.reader.batch-size", 1024);
        Preconditions.checkArgument((this.maxBatchSize > 0 ? 1 : 0) != 0, (String)("invalid Parquet reader batch size: " + this.maxBatchSize));
    }

    public CloseableIterator<ColumnarBatch> read(String string, StructType structType) {
        final BatchReadSupport batchReadSupport = new BatchReadSupport(this.maxBatchSize, structType);
        final ParquetRecordReader parquetRecordReader = new ParquetRecordReader((ReadSupport)batchReadSupport);
        final boolean bl = structType.indexOf(StructField.METADATA_ROW_INDEX_COLUMN_NAME) >= 0 && structType.get(StructField.METADATA_ROW_INDEX_COLUMN_NAME).isMetadataColumn();
        Path path = new Path(URI.create(string));
        try {
            FileSystem fileSystem = path.getFileSystem(this.configuration);
            FileStatus fileStatus = fileSystem.getFileStatus(path);
            FileSplit fileSplit = new FileSplit(path, 0L, fileStatus.getLen(), new String[0]);
            parquetRecordReader.initialize((InputSplit)fileSplit, this.configuration, Reporter.NULL);
        }
        catch (IOException | InterruptedException exception) {
            throw new RuntimeException(exception);
        }
        return new CloseableIterator<ColumnarBatch>(){
            private boolean hasNotConsumedNextElement;

            public void close() throws IOException {
                parquetRecordReader.close();
            }

            public boolean hasNext() {
                try {
                    if (this.hasNotConsumedNextElement) {
                        return true;
                    }
                    this.hasNotConsumedNextElement = parquetRecordReader.nextKeyValue();
                    return this.hasNotConsumedNextElement;
                }
                catch (IOException | InterruptedException exception) {
                    throw new RuntimeException(exception);
                }
            }

            public ColumnarBatch next() {
                if (!this.hasNotConsumedNextElement) {
                    throw new NoSuchElementException();
                }
                int n = 0;
                do {
                    this.hasNotConsumedNextElement = false;
                    try {
                        long l = 0L;
                        if (bl) {
                            l = parquetRecordReader.getCurrentRowIndex();
                        }
                        batchReadSupport.finalizeCurrentRow(l);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                } while (++n < ParquetBatchReader.this.maxBatchSize && this.hasNext());
                return batchReadSupport.getDataAsColumnarBatch(n);
            }
        };
    }

    public static class RowRecordCollector
    extends RecordMaterializer<Object> {
        private static final Object FAKE_ROW_RECORD = new Object();
        private final RowConverter rowRecordGroupConverter;

        public RowRecordCollector(int n, StructType structType, MessageType messageType) {
            this.rowRecordGroupConverter = new RowConverter(n, structType, (GroupType)messageType);
        }

        public void skipCurrentRecord() {
            super.skipCurrentRecord();
        }

        public Object getCurrentRecord() {
            return FAKE_ROW_RECORD;
        }

        public GroupConverter getRootConverter() {
            return this.rowRecordGroupConverter;
        }

        public ColumnarBatch getDataAsColumnarBatch(int n) {
            return this.rowRecordGroupConverter.getDataAsColumnarBatch(n);
        }

        public void finalizeCurrentRow(long l) {
            this.rowRecordGroupConverter.finalizeCurrentRow(l);
        }
    }

    public static class BatchReadSupport
    extends ReadSupport<Object> {
        private final int maxBatchSize;
        private final StructType readSchema;
        private RowRecordCollector rowRecordCollector;

        public BatchReadSupport(int n, StructType structType) {
            this.maxBatchSize = n;
            this.readSchema = Objects.requireNonNull(structType, "readSchema is not null");
        }

        public ReadSupport.ReadContext init(InitContext initContext) {
            return new ReadSupport.ReadContext(ParquetSchemaUtils.pruneSchema((GroupType)initContext.getFileSchema(), this.readSchema));
        }

        public RecordMaterializer<Object> prepareForRead(Configuration configuration, Map<String, String> map, MessageType messageType, ReadSupport.ReadContext readContext) {
            this.rowRecordCollector = new RowRecordCollector(this.maxBatchSize, this.readSchema, messageType);
            return this.rowRecordCollector;
        }

        public ColumnarBatch getDataAsColumnarBatch(int n) {
            return this.rowRecordCollector.getDataAsColumnarBatch(n);
        }

        public void finalizeCurrentRow(long l) {
            this.rowRecordCollector.finalizeCurrentRow(l);
        }
    }
}

