/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.parquet;

import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.FieldMetadata;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

class ParquetSchemaUtils {
    private ParquetSchemaUtils() {
    }

    static MessageType pruneSchema(GroupType groupType, StructType structType) {
        boolean bl = ParquetSchemaUtils.hasFieldIds((DataType)structType);
        return new MessageType("fileSchema", ParquetSchemaUtils.pruneFields(groupType, structType, bl));
    }

    static Type findSubFieldType(GroupType groupType, StructField structField, Map<Integer, Type> map) {
        int n;
        Object object;
        if (ParquetSchemaUtils.hasFieldId(structField.getMetadata()).booleanValue() && (object = map.get(n = ParquetSchemaUtils.getFieldId(structField.getMetadata()))) != null) {
            return object;
        }
        String string = structField.getName();
        if (groupType.containsField(string)) {
            return groupType.getType(string);
        }
        for (Type type : groupType.getFields()) {
            if (!type.getName().equalsIgnoreCase(string)) continue;
            return type;
        }
        return null;
    }

    static Map<Integer, Type> getParquetFieldToTypeMap(GroupType groupType) {
        return groupType.getFields().stream().filter(type -> type.getId() != null).collect(Collectors.toMap(type -> type.getId().intValue(), type -> type, (type, type2) -> {
            throw new IllegalStateException(String.format("Parquet file contains multiple columns (%s, %s) with the same field id", type, type2));
        }));
    }

    private static List<Type> pruneFields(GroupType groupType, StructType structType, boolean bl) {
        Map<Integer, Type> map = ParquetSchemaUtils.getParquetFieldToTypeMap(groupType);
        return structType.fields().stream().map(structField -> {
            Type type = ParquetSchemaUtils.findSubFieldType(groupType, structField, map);
            if (type != null) {
                return ParquetSchemaUtils.prunedType(type, structField.getDataType(), bl);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Type prunedType(Type type, DataType dataType, boolean bl) {
        if (type instanceof GroupType && dataType instanceof StructType) {
            GroupType groupType = (GroupType)type;
            StructType structType = (StructType)dataType;
            return groupType.withNewFields(ParquetSchemaUtils.pruneFields(groupType, structType, bl));
        }
        return type;
    }

    private static boolean hasFieldIds(DataType dataType) {
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            for (StructField structField : structType.fields()) {
                if (!ParquetSchemaUtils.hasFieldId(structField.getMetadata()).booleanValue() && !ParquetSchemaUtils.hasFieldIds(structField.getDataType())) continue;
                return true;
            }
            return false;
        }
        if (dataType instanceof ArrayType) {
            return ParquetSchemaUtils.hasFieldIds(((ArrayType)dataType).getElementType());
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            return ParquetSchemaUtils.hasFieldIds(mapType.getKeyType()) || ParquetSchemaUtils.hasFieldIds(mapType.getValueType());
        }
        return false;
    }

    private static Boolean hasFieldId(FieldMetadata fieldMetadata) {
        return fieldMetadata.contains("parquet.field.id");
    }

    private static int getFieldId(FieldMetadata fieldMetadata) {
        Long l = (Long)fieldMetadata.get("parquet.field.id");
        long l2 = l;
        int n = (int)l2;
        Preconditions.checkArgument(((long)n == l2 ? 1 : 0) != 0, (String)"Field id out of range", (Object[])new Object[]{l2});
        return n;
    }
}

