/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.parquet;

import io.delta.kernel.defaults.internal.DefaultKernelUtils;
import io.delta.kernel.defaults.internal.parquet.ParquetConverters;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.TimestampType;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class TimestampConverters {
    public static Converter createTimestampConverter(int n, Type type) {
        PrimitiveType primitiveType = type.asPrimitiveType();
        if (primitiveType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT96) {
            return new TimestampBinaryConverter(n);
        }
        if (primitiveType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT64) {
            LogicalTypeAnnotation logicalTypeAnnotation = primitiveType.getLogicalTypeAnnotation();
            if (!(logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)) {
                throw new RuntimeException(String.format("Unsupported timestamp column with Parquet type %s.", type));
            }
            LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalTypeAnnotation = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalTypeAnnotation;
            Preconditions.checkArgument((boolean)timestampLogicalTypeAnnotation.isAdjustedToUTC(), (String)"TimestampType must have parquet TimeType(isAdjustedToUTC=true)");
            if (timestampLogicalTypeAnnotation.getUnit() == LogicalTypeAnnotation.TimeUnit.MICROS) {
                return new ParquetConverters.LongColumnConverter((DataType)TimestampType.TIMESTAMP, n);
            }
            if (timestampLogicalTypeAnnotation.getUnit() == LogicalTypeAnnotation.TimeUnit.MILLIS) {
                return new TimestampMillisConverter(n);
            }
            throw new UnsupportedOperationException(String.format("Unsupported parquet TimeType unit=%s", timestampLogicalTypeAnnotation.getUnit()));
        }
        throw new RuntimeException(String.format("Unsupported timestamp column with Parquet type %s.", type));
    }

    public static class TimestampBinaryConverter
    extends ParquetConverters.LongColumnConverter {
        TimestampBinaryConverter(int n) {
            super((DataType)TimestampType.TIMESTAMP, n);
        }

        private long binaryToSQLTimestamp(Binary binary) {
            Preconditions.checkArgument((binary.length() == 12 ? 1 : 0) != 0, (String)String.format("Timestamps (with nanoseconds) are expected to be stored in 12-byte long binaries. Found a %s-byte binary instead.", binary.length()));
            ByteBuffer byteBuffer = binary.toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
            long l = byteBuffer.getLong();
            int n = byteBuffer.getInt();
            return DefaultKernelUtils.fromJulianDay(n, l);
        }

        public void addBinary(Binary binary) {
            long l;
            long l2 = l = this.binaryToSQLTimestamp(binary);
            super.addLong(l2);
        }

        @Override
        public void addLong(long l) {
            throw new UnsupportedOperationException(this.getClass().getName());
        }
    }

    public static class TimestampMillisConverter
    extends ParquetConverters.LongColumnConverter {
        TimestampMillisConverter(int n) {
            super((DataType)TimestampType.TIMESTAMP, n);
        }

        @Override
        public void addLong(long l) {
            super.addLong(DefaultKernelUtils.millisToMicros(l));
        }
    }
}

