/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal;

import io.delta.kernel.expressions.Column;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.StructType;
import java.time.LocalDate;
import java.util.concurrent.TimeUnit;

public class DefaultKernelUtils {
    private static final LocalDate EPOCH = LocalDate.ofEpochDay(0L);
    static int JULIAN_DAY_OF_EPOCH = 2440588;

    private DefaultKernelUtils() {
    }

    public static long fromJulianDay(int n, long l) {
        return (long)(n - JULIAN_DAY_OF_EPOCH) * 86400000000L + l / 1000L;
    }

    public static Tuple2<Integer, Long> toJulianDay(long l) {
        long l2 = l + (long)JULIAN_DAY_OF_EPOCH * 86400000000L;
        long l3 = l2 / 86400000000L;
        long l4 = l2 % 86400000000L;
        return new Tuple2((Object)((int)l3), (Object)TimeUnit.MICROSECONDS.toNanos(l4));
    }

    public static long millisToMicros(long l) {
        return Math.multiplyExact(l, 1000L);
    }

    public static DataType getDataType(StructType structType, Column column) {
        StructType structType2 = structType;
        for (String string : column.getNames()) {
            if (!(structType2 instanceof StructType)) {
                throw new IllegalArgumentException(String.format("Cannot resolve column (%s) in schema: %s", column, structType));
            }
            StructType structType3 = structType2;
            if (!structType3.fieldNames().contains(string)) {
                throw new IllegalArgumentException(String.format("Cannot resolve column (%s) in schema: %s", column, structType));
            }
            structType2 = structType3.get(string).getDataType();
        }
        return structType2;
    }
}

