/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.data.vector;

import io.delta.kernel.data.ArrayValue;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.MapValue;
import io.delta.kernel.data.Row;
import io.delta.kernel.defaults.internal.data.vector.DefaultSubFieldVector;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import io.delta.kernel.types.TimestampNTZType;
import io.delta.kernel.types.TimestampType;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.Function;

public class DefaultGenericVector
implements ColumnVector {
    private final int size;
    private final DataType dataType;
    private final Function<Integer, Object> rowIdToValueAccessor;

    public static DefaultGenericVector fromArray(DataType dataType, Object[] objectArray) {
        return new DefaultGenericVector(objectArray.length, dataType, n -> objectArray[n]);
    }

    public static DefaultGenericVector fromList(DataType dataType, List<Object> list) {
        return new DefaultGenericVector(list.size(), dataType, n -> list.get((int)n));
    }

    protected DefaultGenericVector(int n, DataType dataType, Function<Integer, Object> function) {
        this.size = n;
        this.dataType = dataType;
        this.rowIdToValueAccessor = function;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public int getSize() {
        return this.size;
    }

    public void close() {
    }

    public boolean isNullAt(int n) {
        this.assertValidRowId(n);
        return this.rowIdToValueAccessor.apply(n) == null;
    }

    public boolean getBoolean(int n) {
        this.assertValidRowId(n);
        this.throwIfUnsafeAccess(BooleanType.class, "boolean");
        return (Boolean)this.rowIdToValueAccessor.apply(n);
    }

    public byte getByte(int n) {
        this.assertValidRowId(n);
        this.throwIfUnsafeAccess(ByteType.class, "byte");
        return (Byte)this.rowIdToValueAccessor.apply(n);
    }

    public short getShort(int n) {
        this.assertValidRowId(n);
        this.throwIfUnsafeAccess(ShortType.class, "short");
        return (Short)this.rowIdToValueAccessor.apply(n);
    }

    public int getInt(int n) {
        this.assertValidRowId(n);
        this.throwIfUnsafeAccess(IntegerType.class, DateType.class, this.dataType.toString());
        return (Integer)this.rowIdToValueAccessor.apply(n);
    }

    public long getLong(int n) {
        this.assertValidRowId(n);
        this.throwIfUnsafeAccess(LongType.class, TimestampType.class, TimestampNTZType.class, this.dataType.toString());
        return (Long)this.rowIdToValueAccessor.apply(n);
    }

    public float getFloat(int n) {
        this.assertValidRowId(n);
        this.throwIfUnsafeAccess(FloatType.class, "float");
        return ((Float)this.rowIdToValueAccessor.apply(n)).floatValue();
    }

    public double getDouble(int n) {
        this.assertValidRowId(n);
        this.throwIfUnsafeAccess(DoubleType.class, "double");
        return (Double)this.rowIdToValueAccessor.apply(n);
    }

    public String getString(int n) {
        this.assertValidRowId(n);
        this.throwIfUnsafeAccess(StringType.class, "string");
        return (String)this.rowIdToValueAccessor.apply(n);
    }

    public BigDecimal getDecimal(int n) {
        this.assertValidRowId(n);
        this.throwIfUnsafeAccess(DecimalType.class, "decimal");
        return (BigDecimal)this.rowIdToValueAccessor.apply(n);
    }

    public byte[] getBinary(int n) {
        this.assertValidRowId(n);
        this.throwIfUnsafeAccess(BinaryType.class, "binary");
        return (byte[])this.rowIdToValueAccessor.apply(n);
    }

    public ArrayValue getArray(int n) {
        this.assertValidRowId(n);
        this.throwIfUnsafeAccess(ArrayType.class, "array");
        return (ArrayValue)this.rowIdToValueAccessor.apply(n);
    }

    public MapValue getMap(int n) {
        this.assertValidRowId(n);
        this.throwIfUnsafeAccess(MapType.class, "map");
        return (MapValue)this.rowIdToValueAccessor.apply(n);
    }

    public ColumnVector getChild(int n2) {
        this.throwIfUnsafeAccess(StructType.class, "struct");
        StructType structType = (StructType)this.dataType;
        return new DefaultSubFieldVector(this.getSize(), structType.at(n2).getDataType(), n2, n -> (Row)this.rowIdToValueAccessor.apply((Integer)n));
    }

    private void throwIfUnsafeAccess(Class<? extends DataType> clazz, String string) {
        if (!clazz.isAssignableFrom(this.dataType.getClass())) {
            String string2 = String.format("Trying to access a `%s` value from vector of type `%s`", string, this.dataType);
            throw new UnsupportedOperationException(string2);
        }
    }

    private void throwIfUnsafeAccess(Class<? extends DataType> clazz, Class<? extends DataType> clazz2, String string) {
        if (!clazz.isAssignableFrom(this.dataType.getClass()) && !clazz2.isAssignableFrom(this.dataType.getClass())) {
            String string2 = String.format("Trying to access a `%s` value from vector of type `%s`", string, this.dataType);
            throw new UnsupportedOperationException(string2);
        }
    }

    private void throwIfUnsafeAccess(Class<? extends DataType> clazz, Class<? extends DataType> clazz2, Class<? extends DataType> clazz3, String string) {
        if (!(clazz.isAssignableFrom(this.dataType.getClass()) || clazz2.isAssignableFrom(this.dataType.getClass()) || clazz3.isAssignableFrom(this.dataType.getClass()))) {
            String string2 = String.format("Trying to access a `%s` value from vector of type `%s`", string, this.dataType);
            throw new UnsupportedOperationException(string2);
        }
    }

    private void assertValidRowId(int n) {
        Preconditions.checkArgument((n < this.size ? 1 : 0) != 0, (String)("Invalid rowId: " + n + ", max allowed rowId is: " + (this.size - 1)));
    }
}

