/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.expressions;

import io.delta.kernel.data.ArrayValue;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.MapValue;
import io.delta.kernel.expressions.Expression;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.TimestampNTZType;
import io.delta.kernel.types.TimestampType;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

class DefaultExpressionUtils {
    private DefaultExpressionUtils() {
    }

    static boolean[] evalNullability(ColumnVector columnVector, ColumnVector columnVector2) {
        int n = columnVector.getSize();
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = columnVector.isNullAt(i) || columnVector2.isNullAt(i);
        }
        return blArray;
    }

    static ColumnVector booleanWrapperVector(final ColumnVector columnVector, final Function<Integer, Boolean> function, final Function<Integer, Boolean> function2) {
        return new ColumnVector(){

            public DataType getDataType() {
                return BooleanType.BOOLEAN;
            }

            public int getSize() {
                return columnVector.getSize();
            }

            public void close() {
                columnVector.close();
            }

            public boolean isNullAt(int n) {
                return (Boolean)function2.apply(n);
            }

            public boolean getBoolean(int n) {
                return (Boolean)function.apply(n);
            }
        };
    }

    static int[] compare(ColumnVector columnVector, ColumnVector columnVector2) {
        Preconditions.checkArgument((columnVector.getSize() == columnVector2.getSize() ? 1 : 0) != 0, (String)"Left and right operand have different vector sizes.");
        DataType dataType = columnVector.getDataType();
        int n = columnVector.getSize();
        int[] nArray = new int[n];
        if (dataType instanceof BooleanType) {
            DefaultExpressionUtils.compareBoolean(columnVector, columnVector2, nArray);
        } else if (dataType instanceof ByteType) {
            DefaultExpressionUtils.compareByte(columnVector, columnVector2, nArray);
        } else if (dataType instanceof ShortType) {
            DefaultExpressionUtils.compareShort(columnVector, columnVector2, nArray);
        } else if (dataType instanceof IntegerType || dataType instanceof DateType) {
            DefaultExpressionUtils.compareInt(columnVector, columnVector2, nArray);
        } else if (dataType instanceof LongType || dataType instanceof TimestampType || dataType instanceof TimestampNTZType) {
            DefaultExpressionUtils.compareLong(columnVector, columnVector2, nArray);
        } else if (dataType instanceof FloatType) {
            DefaultExpressionUtils.compareFloat(columnVector, columnVector2, nArray);
        } else if (dataType instanceof DoubleType) {
            DefaultExpressionUtils.compareDouble(columnVector, columnVector2, nArray);
        } else if (dataType instanceof DecimalType) {
            DefaultExpressionUtils.compareDecimal(columnVector, columnVector2, nArray);
        } else if (dataType instanceof StringType) {
            DefaultExpressionUtils.compareString(columnVector, columnVector2, nArray);
        } else if (dataType instanceof BinaryType) {
            DefaultExpressionUtils.compareBinary(columnVector, columnVector2, nArray);
        } else {
            throw new UnsupportedOperationException(dataType + " can not be compared.");
        }
        return nArray;
    }

    static void compareBoolean(ColumnVector columnVector, ColumnVector columnVector2, int[] nArray) {
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i) || columnVector2.isNullAt(i)) continue;
            nArray[i] = Boolean.compare(columnVector.getBoolean(i), columnVector2.getBoolean(i));
        }
    }

    static void compareByte(ColumnVector columnVector, ColumnVector columnVector2, int[] nArray) {
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i) || columnVector2.isNullAt(i)) continue;
            nArray[i] = Byte.compare(columnVector.getByte(i), columnVector2.getByte(i));
        }
    }

    static void compareShort(ColumnVector columnVector, ColumnVector columnVector2, int[] nArray) {
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i) || columnVector2.isNullAt(i)) continue;
            nArray[i] = Short.compare(columnVector.getShort(i), columnVector2.getShort(i));
        }
    }

    static void compareInt(ColumnVector columnVector, ColumnVector columnVector2, int[] nArray) {
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i) || columnVector2.isNullAt(i)) continue;
            nArray[i] = Integer.compare(columnVector.getInt(i), columnVector2.getInt(i));
        }
    }

    static void compareLong(ColumnVector columnVector, ColumnVector columnVector2, int[] nArray) {
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i) || columnVector2.isNullAt(i)) continue;
            nArray[i] = Long.compare(columnVector.getLong(i), columnVector2.getLong(i));
        }
    }

    static void compareFloat(ColumnVector columnVector, ColumnVector columnVector2, int[] nArray) {
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i) || columnVector2.isNullAt(i)) continue;
            nArray[i] = Float.compare(columnVector.getFloat(i), columnVector2.getFloat(i));
        }
    }

    static void compareDouble(ColumnVector columnVector, ColumnVector columnVector2, int[] nArray) {
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i) || columnVector2.isNullAt(i)) continue;
            nArray[i] = Double.compare(columnVector.getDouble(i), columnVector2.getDouble(i));
        }
    }

    static void compareString(ColumnVector columnVector, ColumnVector columnVector2, int[] nArray) {
        Comparator<String> comparator = Comparator.naturalOrder();
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i) || columnVector2.isNullAt(i)) continue;
            nArray[i] = comparator.compare(columnVector.getString(i), columnVector2.getString(i));
        }
    }

    static void compareDecimal(ColumnVector columnVector, ColumnVector columnVector2, int[] nArray) {
        Comparator<BigDecimal> comparator = Comparator.naturalOrder();
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i) || columnVector2.isNullAt(i)) continue;
            nArray[i] = comparator.compare(columnVector.getDecimal(i), columnVector2.getDecimal(i));
        }
    }

    static void compareBinary(ColumnVector columnVector, ColumnVector columnVector2, int[] nArray) {
        Comparator comparator = (byArray, byArray2) -> {
            for (int i = 0; i < ((byte[])byArray).length && i < ((byte[])byArray2).length; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                return Byte.compare(byArray[i], byArray2[i]);
            }
            return Integer.compare(((byte[])byArray).length, ((byte[])byArray2).length);
        };
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i) || columnVector2.isNullAt(i)) continue;
            nArray[i] = comparator.compare(columnVector.getBinary(i), columnVector2.getBinary(i));
        }
    }

    static Expression childAt(Expression expression, int n) {
        return (Expression)expression.getChildren().get(n);
    }

    static ColumnVector combinationVector(final List<ColumnVector> list, final Function<Integer, Integer> function) {
        return new ColumnVector(){
            private int lastLookupRowId = -1;
            private ColumnVector lastLookupVector = null;

            public DataType getDataType() {
                return ((ColumnVector)list.get(0)).getDataType();
            }

            public int getSize() {
                return ((ColumnVector)list.get(0)).getSize();
            }

            public void close() {
                Utils.closeCloseables((AutoCloseable[])((AutoCloseable[])list.toArray(new ColumnVector[0])));
            }

            public boolean isNullAt(int n) {
                return this.getVector(n).isNullAt(n);
            }

            public boolean getBoolean(int n) {
                return this.getVector(n).getBoolean(n);
            }

            public byte getByte(int n) {
                return this.getVector(n).getByte(n);
            }

            public short getShort(int n) {
                return this.getVector(n).getShort(n);
            }

            public int getInt(int n) {
                return this.getVector(n).getInt(n);
            }

            public long getLong(int n) {
                return this.getVector(n).getLong(n);
            }

            public float getFloat(int n) {
                return this.getVector(n).getFloat(n);
            }

            public double getDouble(int n) {
                return this.getVector(n).getDouble(n);
            }

            public byte[] getBinary(int n) {
                return this.getVector(n).getBinary(n);
            }

            public String getString(int n) {
                return this.getVector(n).getString(n);
            }

            public BigDecimal getDecimal(int n) {
                return this.getVector(n).getDecimal(n);
            }

            public MapValue getMap(int n) {
                return this.getVector(n).getMap(n);
            }

            public ArrayValue getArray(int n) {
                return this.getVector(n).getArray(n);
            }

            public ColumnVector getChild(int n) {
                return DefaultExpressionUtils.combinationVector(list.stream().map(columnVector -> columnVector.getChild(n)).collect(Collectors.toList()), function);
            }

            private ColumnVector getVector(int n) {
                if (n == this.lastLookupRowId) {
                    return this.lastLookupVector;
                }
                this.lastLookupRowId = n;
                this.lastLookupVector = (ColumnVector)list.get((Integer)function.apply(n));
                return this.lastLookupVector;
            }
        };
    }
}

