/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.parquet;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.defaults.internal.data.vector.DefaultMapVector;
import io.delta.kernel.defaults.internal.parquet.ParquetColumnReaders;
import io.delta.kernel.defaults.internal.parquet.RepeatedValueConverter;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.MapType;
import java.util.Optional;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.schema.GroupType;

class MapColumnReader
extends RepeatedValueConverter {
    private final MapType typeFromClient;

    MapColumnReader(int n, MapType mapType, GroupType groupType) {
        super(n, MapColumnReader.createElementConverters(n, mapType, groupType));
        this.typeFromClient = mapType;
    }

    @Override
    public ColumnVector getDataColumnVector(int n) {
        ColumnVector[] columnVectorArray = this.getElementDataVectors();
        DefaultMapVector defaultMapVector = new DefaultMapVector(n, (DataType)this.typeFromClient, Optional.of(this.getNullability()), this.getOffsets(), columnVectorArray[0], columnVectorArray[1]);
        this.resetWorkingState();
        return defaultMapVector;
    }

    private static Converter[] createElementConverters(int n, MapType mapType, GroupType groupType) {
        GroupType groupType2 = (GroupType)groupType.getType("key_value");
        Converter[] converterArray = new Converter[]{ParquetColumnReaders.createConverter(n, mapType.getKeyType(), groupType2.getType("key")), ParquetColumnReaders.createConverter(n, mapType.getValueType(), groupType2.getType("value"))};
        return converterArray;
    }
}

