/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.expressions;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.MapValue;
import io.delta.kernel.defaults.internal.DefaultEngineErrors;
import io.delta.kernel.defaults.internal.expressions.ImplicitCastExpression;
import io.delta.kernel.expressions.Expression;
import io.delta.kernel.expressions.ScalarExpression;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.StringType;
import java.util.Arrays;

class ElementAtEvaluator {
    private ElementAtEvaluator() {
    }

    static ScalarExpression validateAndTransform(ScalarExpression scalarExpression, Expression expression, DataType dataType, Expression expression2, DataType dataType2) {
        MapType mapType = ElementAtEvaluator.validateSupportedMapType((Expression)scalarExpression, dataType);
        DataType dataType3 = mapType.getKeyType();
        if (!dataType3.equivalent(dataType2)) {
            if (ImplicitCastExpression.canCastTo(dataType2, dataType3)) {
                expression2 = new ImplicitCastExpression(expression2, dataType3);
            } else {
                String string = String.format("lookup key type (%s) is different from the map key type (%s)", dataType2, mapType.getKeyType());
                throw DefaultEngineErrors.unsupportedExpressionException((Expression)scalarExpression, string);
            }
        }
        return new ScalarExpression(scalarExpression.getName(), Arrays.asList(expression, expression2));
    }

    static ColumnVector eval(final ColumnVector columnVector, final ColumnVector columnVector2) {
        return new ColumnVector(){
            private int lastLookupRowId = -1;
            private String lastLookupValue = null;

            public DataType getDataType() {
                return ((MapType)columnVector.getDataType()).getValueType();
            }

            public int getSize() {
                return columnVector.getSize();
            }

            public void close() {
                Utils.closeCloseables((AutoCloseable[])new AutoCloseable[]{columnVector, columnVector2});
            }

            public boolean isNullAt(int n) {
                if (n == this.lastLookupRowId) {
                    return this.lastLookupValue == null;
                }
                return columnVector.isNullAt(n) || this.lookupValue(n) == null;
            }

            public String getString(int n) {
                this.lookupValue(n);
                return this.lastLookupValue == null ? null : this.lastLookupValue;
            }

            private Object lookupValue(int n) {
                if (n == this.lastLookupRowId) {
                    return this.lastLookupValue;
                }
                this.lastLookupRowId = n;
                String string = columnVector2.getString(n);
                this.lastLookupValue = this.findValueForKey(columnVector.getMap(n), string);
                return this.lastLookupValue;
            }

            private String findValueForKey(MapValue mapValue, String string) {
                ColumnVector columnVector3 = mapValue.getKeys();
                for (int i = 0; i < mapValue.getSize(); ++i) {
                    if ((!columnVector3.isNullAt(i) || string != null) && (columnVector3.isNullAt(i) || !columnVector3.getString(i).equals(string))) continue;
                    return mapValue.getValues().isNullAt(i) ? null : mapValue.getValues().getString(i);
                }
                return null;
            }
        };
    }

    private static MapType validateSupportedMapType(Expression expression, DataType dataType) {
        Preconditions.checkArgument((boolean)(dataType instanceof MapType), (String)("expected a map type input as first argument: " + expression));
        MapType mapType = (MapType)dataType;
        if (mapType.getKeyType().equivalent((DataType)StringType.STRING) && mapType.getValueType().equivalent((DataType)StringType.STRING)) {
            return mapType;
        }
        throw new UnsupportedOperationException(String.format("%s: Supported only on type map(string, string) input data", expression));
    }
}

