/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.parquet;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.defaults.internal.data.vector.DefaultArrayVector;
import io.delta.kernel.defaults.internal.parquet.ParquetColumnReaders;
import io.delta.kernel.defaults.internal.parquet.RepeatedValueConverter;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.DataType;
import java.util.Optional;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.Type;

class ArrayColumnReader
extends RepeatedValueConverter {
    private final ArrayType typeFromClient;

    ArrayColumnReader(int n, ArrayType arrayType, GroupType groupType) {
        super(n, ArrayColumnReader.createElementConverter(n, arrayType, groupType));
        this.typeFromClient = arrayType;
    }

    @Override
    public ColumnVector getDataColumnVector(int n) {
        DefaultArrayVector defaultArrayVector = new DefaultArrayVector(n, (DataType)this.typeFromClient, Optional.of(this.getNullability()), this.getOffsets(), this.getElementDataVectors()[0]);
        this.resetWorkingState();
        return defaultArrayVector;
    }

    private static Converter createElementConverter(int n, ArrayType arrayType, GroupType groupType) {
        Preconditions.checkArgument((groupType.getFieldCount() == 1 ? 1 : 0) != 0, (String)("Expected exactly one field in the array type, but got: " + groupType));
        GroupType groupType2 = groupType.getType(0).asGroupType();
        Preconditions.checkArgument((groupType2.getFieldCount() == 1 ? 1 : 0) != 0, (String)"Expected exactly one field in the repeated group");
        Type type = groupType2.getType(0);
        return ParquetColumnReaders.createConverter(n, arrayType.getElementType(), type);
    }
}

