/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.data;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.Row;
import io.delta.kernel.defaults.internal.data.DefaultColumnarBatch;
import io.delta.kernel.defaults.internal.data.vector.DefaultSubFieldVector;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class DefaultRowBasedColumnarBatch
implements ColumnarBatch {
    private final StructType schema;
    private final List<Row> rows;
    private final List<Optional<ColumnVector>> columnVectors;

    public DefaultRowBasedColumnarBatch(StructType structType, List<Row> list) {
        this.schema = structType;
        this.rows = list;
        this.columnVectors = new ArrayList<Optional<ColumnVector>>(structType.length());
        for (int i = 0; i < structType.length(); ++i) {
            this.columnVectors.add(Optional.empty());
        }
    }

    public StructType getSchema() {
        return this.schema;
    }

    public int getSize() {
        return this.rows.size();
    }

    public ColumnVector getColumnVector(int n2) {
        if (n2 < 0 || n2 >= this.columnVectors.size()) {
            throw new IllegalArgumentException("Invalid ordinal: " + n2);
        }
        if (!this.columnVectors.get(n2).isPresent()) {
            StructField structField = this.schema.at(n2);
            DefaultSubFieldVector defaultSubFieldVector = new DefaultSubFieldVector(this.getSize(), structField.getDataType(), n2, n -> this.rows.get((int)n));
            this.columnVectors.set(n2, Optional.of(defaultSubFieldVector));
        }
        return this.columnVectors.get(n2).get();
    }

    public ColumnarBatch withNewColumn(int n, StructField structField, ColumnVector columnVector) {
        if (n < 0 || n >= this.columnVectors.size() + 1) {
            throw new IllegalArgumentException("Invalid ordinal: " + n);
        }
        ArrayList<StructField> arrayList = new ArrayList<StructField>(this.schema.fields());
        arrayList.add(n, structField);
        StructType structType = new StructType(arrayList);
        for (int i = 0; i < this.columnVectors.size(); ++i) {
            this.getColumnVector(i);
        }
        ArrayList<Optional<ColumnVector>> arrayList2 = new ArrayList<Optional<ColumnVector>>(this.columnVectors);
        arrayList2.add(n, Optional.of(columnVector));
        ColumnVector[] columnVectorArray = new ColumnVector[arrayList2.size()];
        for (int i = 0; i < columnVectorArray.length; ++i) {
            columnVectorArray[i] = (ColumnVector)((Optional)arrayList2.get(i)).get();
        }
        return new DefaultColumnarBatch(this.getSize(), structType, columnVectorArray);
    }

    public ColumnarBatch withDeletedColumnAt(int n) {
        if (n < 0 || n >= this.columnVectors.size()) {
            throw new IllegalArgumentException("Invalid ordinal: " + n);
        }
        ArrayList arrayList = new ArrayList(this.schema.fields());
        arrayList.remove(n);
        StructType structType = new StructType(arrayList);
        for (int i = 0; i < this.columnVectors.size(); ++i) {
            if (i == n) continue;
            this.getColumnVector(i);
        }
        ArrayList<Optional<ColumnVector>> arrayList2 = new ArrayList<Optional<ColumnVector>>(this.columnVectors);
        arrayList2.remove(n);
        ColumnVector[] columnVectorArray = new ColumnVector[arrayList2.size()];
        for (int i = 0; i < columnVectorArray.length; ++i) {
            columnVectorArray[i] = (ColumnVector)((Optional)arrayList2.get(i)).get();
        }
        return new DefaultColumnarBatch(this.getSize(), structType, columnVectorArray);
    }
}

