/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.data.vector;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.MapValue;
import io.delta.kernel.defaults.internal.data.vector.AbstractColumnVector;
import io.delta.kernel.defaults.internal.data.vector.DefaultViewVector;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.DataType;
import java.util.Objects;
import java.util.Optional;

public class DefaultMapVector
extends AbstractColumnVector {
    private final int[] offsets;
    private final ColumnVector keyVector;
    private final ColumnVector valueVector;

    public DefaultMapVector(int n, DataType dataType, Optional<boolean[]> optional, int[] nArray, ColumnVector columnVector, ColumnVector columnVector2) {
        super(n, dataType, optional);
        Preconditions.checkArgument((nArray.length >= n + 1 ? 1 : 0) != 0, (String)"invalid offset array size");
        this.offsets = Objects.requireNonNull(nArray, "offsets is null");
        this.keyVector = Objects.requireNonNull(columnVector, "keyVector is null");
        this.valueVector = Objects.requireNonNull(columnVector2, "valueVector is null");
    }

    @Override
    public MapValue getMap(int n) {
        this.checkValidRowId(n);
        if (this.isNullAt(n)) {
            return null;
        }
        final int n2 = this.offsets[n];
        final int n3 = this.offsets[n + 1];
        return new MapValue(){
            private final ColumnVector keys;
            private final ColumnVector values;
            {
                this.keys = new DefaultViewVector(DefaultMapVector.this.keyVector, n2, n3);
                this.values = new DefaultViewVector(DefaultMapVector.this.valueVector, n2, n3);
            }

            public int getSize() {
                return this.keys.getSize();
            }

            public ColumnVector getKeys() {
                return this.keys;
            }

            public ColumnVector getValues() {
                return this.values;
            }
        };
    }
}

