/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.delta.kernel.data.ArrayValue;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.MapValue;
import io.delta.kernel.data.Row;
import io.delta.kernel.defaults.internal.data.DefaultJsonRow;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import java.io.IOException;

public class JsonUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private JsonUtils() {
    }

    public static String rowToJson(Row row) {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)row);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new RuntimeException("Could not serialize row object to JSON", jsonProcessingException);
        }
    }

    public static Row rowFromJson(String string, StructType structType) {
        try {
            JsonNode jsonNode = OBJECT_MAPPER.readTree(string);
            return new DefaultJsonRow((ObjectNode)jsonNode, structType);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new RuntimeException(String.format("Could not parse JSON: %s", string), jsonProcessingException);
        }
    }

    private static void assertSupportedMapType(MapType mapType) {
        Preconditions.checkArgument((boolean)(mapType.getKeyType() instanceof StringType), (String)"Only STRING type keys are supported in MAP type in JSON serialization");
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new SimpleModule().addSerializer(Row.class, (JsonSerializer)new RowSerializer()));
    }

    public static class RowSerializer
    extends StdSerializer<Row> {
        public RowSerializer() {
            super(Row.class);
        }

        public void serialize(Row row, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            this.writeRow(jsonGenerator, row, row.getSchema());
        }

        private void writeRow(JsonGenerator jsonGenerator, Row row, StructType structType) throws IOException {
            jsonGenerator.writeStartObject();
            for (int i = 0; i < structType.length(); ++i) {
                StructField structField = structType.at(i);
                if (row.isNullAt(i)) continue;
                jsonGenerator.writeFieldName(structField.getName());
                this.writeValue(jsonGenerator, row, i, structField.getDataType());
            }
            jsonGenerator.writeEndObject();
        }

        private void writeStruct(JsonGenerator jsonGenerator, ColumnVector columnVector, StructType structType, int n) throws IOException {
            jsonGenerator.writeStartObject();
            for (int i = 0; i < structType.length(); ++i) {
                StructField structField = structType.at(i);
                ColumnVector columnVector2 = columnVector.getChild(i);
                if (columnVector2.isNullAt(n)) continue;
                jsonGenerator.writeFieldName(structField.getName());
                this.writeValue(jsonGenerator, columnVector2, n, structField.getDataType());
            }
            jsonGenerator.writeEndObject();
        }

        private void writeArrayValue(JsonGenerator jsonGenerator, ArrayValue arrayValue, ArrayType arrayType) throws IOException {
            jsonGenerator.writeStartArray();
            ColumnVector columnVector = arrayValue.getElements();
            for (int i = 0; i < arrayValue.getSize(); ++i) {
                if (columnVector.isNullAt(i)) {
                    jsonGenerator.writeNull();
                    continue;
                }
                this.writeValue(jsonGenerator, arrayValue.getElements(), i, arrayType.getElementType());
            }
            jsonGenerator.writeEndArray();
        }

        private void writeMapValue(JsonGenerator jsonGenerator, MapValue mapValue, MapType mapType) throws IOException {
            JsonUtils.assertSupportedMapType(mapType);
            jsonGenerator.writeStartObject();
            ColumnVector columnVector = mapValue.getKeys();
            ColumnVector columnVector2 = mapValue.getValues();
            for (int i = 0; i < mapValue.getSize(); ++i) {
                jsonGenerator.writeFieldName(columnVector.getString(i));
                if (!columnVector2.isNullAt(i)) {
                    this.writeValue(jsonGenerator, columnVector2, i, mapType.getValueType());
                    continue;
                }
                jsonGenerator.writeNull();
            }
            jsonGenerator.writeEndObject();
        }

        private void writeValue(JsonGenerator jsonGenerator, Row row, int n, DataType dataType) throws IOException {
            Preconditions.checkArgument((!row.isNullAt(n) ? 1 : 0) != 0, (String)"value should not be null");
            if (dataType instanceof BooleanType) {
                jsonGenerator.writeBoolean(row.getBoolean(n));
            } else if (dataType instanceof ByteType) {
                jsonGenerator.writeNumber((short)row.getByte(n));
            } else if (dataType instanceof ShortType) {
                jsonGenerator.writeNumber(row.getShort(n));
            } else if (dataType instanceof IntegerType) {
                jsonGenerator.writeNumber(row.getInt(n));
            } else if (dataType instanceof LongType) {
                jsonGenerator.writeNumber(row.getLong(n));
            } else if (dataType instanceof FloatType) {
                jsonGenerator.writeNumber(row.getFloat(n));
            } else if (dataType instanceof DoubleType) {
                jsonGenerator.writeNumber(row.getDouble(n));
            } else if (dataType instanceof StringType) {
                jsonGenerator.writeString(row.getString(n));
            } else if (dataType instanceof StructType) {
                this.writeRow(jsonGenerator, row.getStruct(n), (StructType)dataType);
            } else if (dataType instanceof ArrayType) {
                this.writeArrayValue(jsonGenerator, row.getArray(n), (ArrayType)dataType);
            } else if (dataType instanceof MapType) {
                this.writeMapValue(jsonGenerator, row.getMap(n), (MapType)dataType);
            } else {
                throw new UnsupportedOperationException("unsupported data type: " + dataType);
            }
        }

        private void writeValue(JsonGenerator jsonGenerator, ColumnVector columnVector, int n, DataType dataType) throws IOException {
            Preconditions.checkArgument((!columnVector.isNullAt(n) ? 1 : 0) != 0, (String)"value should not be null");
            if (dataType instanceof BooleanType) {
                jsonGenerator.writeBoolean(columnVector.getBoolean(n));
            } else if (dataType instanceof ByteType) {
                jsonGenerator.writeNumber((short)columnVector.getByte(n));
            } else if (dataType instanceof ShortType) {
                jsonGenerator.writeNumber(columnVector.getShort(n));
            } else if (dataType instanceof IntegerType) {
                jsonGenerator.writeNumber(columnVector.getInt(n));
            } else if (dataType instanceof LongType) {
                jsonGenerator.writeNumber(columnVector.getLong(n));
            } else if (dataType instanceof FloatType) {
                jsonGenerator.writeNumber(columnVector.getFloat(n));
            } else if (dataType instanceof DoubleType) {
                jsonGenerator.writeNumber(columnVector.getDouble(n));
            } else if (dataType instanceof StringType) {
                jsonGenerator.writeString(columnVector.getString(n));
            } else if (dataType instanceof StructType) {
                this.writeStruct(jsonGenerator, columnVector, (StructType)dataType, n);
            } else if (dataType instanceof ArrayType) {
                this.writeArrayValue(jsonGenerator, columnVector.getArray(n), (ArrayType)dataType);
            } else if (dataType instanceof MapType) {
                this.writeMapValue(jsonGenerator, columnVector.getMap(n), (MapType)dataType);
            } else {
                throw new UnsupportedOperationException("unsupported data type: " + dataType);
            }
        }
    }
}

