/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.parquet;

import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.defaults.internal.parquet.ParquetFilterUtils;
import io.delta.kernel.defaults.internal.parquet.ParquetSchemaUtils;
import io.delta.kernel.defaults.internal.parquet.RowColumnReader;
import io.delta.kernel.exceptions.KernelEngineException;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import java.io.IOException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;

public class ParquetFileReader {
    private final Configuration configuration;
    private final int maxBatchSize;

    public ParquetFileReader(Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration, "configuration is null");
        this.maxBatchSize = configuration.getInt("delta.kernel.default.parquet.reader.batch-size", 1024);
        Preconditions.checkArgument((this.maxBatchSize > 0 ? 1 : 0) != 0, (String)"invalid Parquet reader batch size: %s", (Object[])new Object[]{this.maxBatchSize});
    }

    public CloseableIterator<ColumnarBatch> read(final String string, final StructType structType, final Optional<Predicate> optional) {
        final boolean bl = structType.indexOf(StructField.METADATA_ROW_INDEX_COLUMN_NAME) >= 0 && structType.get(StructField.METADATA_ROW_INDEX_COLUMN_NAME).isMetadataColumn();
        return new CloseableIterator<ColumnarBatch>(){
            private final BatchReadSupport readSupport;
            private ParquetReader<Object> reader;
            private boolean hasNotConsumedNextElement;
            {
                this.readSupport = new BatchReadSupport(ParquetFileReader.this.maxBatchSize, structType);
            }

            public void close() throws IOException {
                Utils.closeCloseables((AutoCloseable[])new AutoCloseable[]{this.reader});
            }

            public boolean hasNext() {
                this.initParquetReaderIfRequired();
                try {
                    if (this.hasNotConsumedNextElement) {
                        return true;
                    }
                    Object object = this.reader.read();
                    this.hasNotConsumedNextElement = object != null;
                    return this.hasNotConsumedNextElement;
                }
                catch (IOException iOException) {
                    throw new KernelEngineException("Error reading Parquet file: " + string, (Throwable)iOException);
                }
            }

            public ColumnarBatch next() {
                if (!this.hasNotConsumedNextElement) {
                    throw new NoSuchElementException();
                }
                int n = 0;
                do {
                    this.hasNotConsumedNextElement = false;
                    long l = bl ? this.reader.getCurrentRowIndex() : -1L;
                    this.readSupport.finalizeCurrentRow(l);
                } while (++n < ParquetFileReader.this.maxBatchSize && this.hasNext());
                return this.readSupport.getDataAsColumnarBatch(n);
            }

            private void initParquetReaderIfRequired() {
                if (this.reader == null) {
                    Object var1_1 = null;
                    try {
                        Configuration configuration = ParquetFileReader.this.configuration;
                        Path path = new Path(string);
                        ParquetMetadata parquetMetadata = org.apache.parquet.hadoop.ParquetFileReader.readFooter((Configuration)configuration, (Path)path);
                        MessageType messageType = parquetMetadata.getFileMetaData().getSchema();
                        Optional<FilterCompat.Filter> optional2 = optional.flatMap(predicate -> ParquetFilterUtils.toParquetFilter(messageType, predicate));
                        this.reader = new ParquetReader.Builder<Object>(path){

                            protected ReadSupport<Object> getReadSupport() {
                                return readSupport;
                            }
                        }.withFilter(optional2.map(FilterCompat::get).orElse(FilterCompat.NOOP)).useRecordFilter(false).useStatsFilter(true).useBloomFilter(false).useDictionaryFilter(false).useColumnIndexFilter(false).build();
                    }
                    catch (IOException iOException) {
                        Utils.closeCloseablesSilently((AutoCloseable[])new AutoCloseable[]{var1_1, this.reader});
                        throw new KernelEngineException("Error reading Parquet file: " + string, (Throwable)iOException);
                    }
                }
            }
        };
    }

    private static class ParquetFileReaderWithFooter
    extends org.apache.parquet.hadoop.ParquetFileReader {
        private final ParquetMetadata footer;

        ParquetFileReaderWithFooter(Path path, Configuration configuration, ParquetMetadata parquetMetadata) throws IOException {
            super(configuration, path, parquetMetadata);
            this.footer = Objects.requireNonNull(parquetMetadata, "footer is null");
        }

        public ParquetMetadata getFooter() {
            return this.footer;
        }
    }

    public static class RowRecordCollector
    extends RecordMaterializer<Object> {
        private static final Object FAKE_ROW_RECORD = new Object();
        private final RowColumnReader rowRecordGroupConverter;

        public RowRecordCollector(int n, StructType structType, MessageType messageType) {
            this.rowRecordGroupConverter = new RowColumnReader(n, structType, (GroupType)messageType);
        }

        public void skipCurrentRecord() {
            super.skipCurrentRecord();
        }

        public Object getCurrentRecord() {
            return FAKE_ROW_RECORD;
        }

        public GroupConverter getRootConverter() {
            return this.rowRecordGroupConverter;
        }

        public ColumnarBatch getDataAsColumnarBatch(int n) {
            return this.rowRecordGroupConverter.getDataAsColumnarBatch(n);
        }

        public void finalizeCurrentRow(long l) {
            this.rowRecordGroupConverter.finalizeCurrentRow(l);
        }
    }

    public static class BatchReadSupport
    extends ReadSupport<Object> {
        private final int maxBatchSize;
        private final StructType readSchema;
        private RowRecordCollector rowRecordCollector;

        public BatchReadSupport(int n, StructType structType) {
            this.maxBatchSize = n;
            this.readSchema = Objects.requireNonNull(structType, "readSchema is not null");
        }

        public ReadSupport.ReadContext init(InitContext initContext) {
            return new ReadSupport.ReadContext(ParquetSchemaUtils.pruneSchema((GroupType)initContext.getFileSchema(), this.readSchema));
        }

        public RecordMaterializer<Object> prepareForRead(Configuration configuration, Map<String, String> map, MessageType messageType, ReadSupport.ReadContext readContext) {
            this.rowRecordCollector = new RowRecordCollector(this.maxBatchSize, this.readSchema, messageType);
            return this.rowRecordCollector;
        }

        public ColumnarBatch getDataAsColumnarBatch(int n) {
            return this.rowRecordCollector.getDataAsColumnarBatch(n);
        }

        public void finalizeCurrentRow(long l) {
            this.rowRecordCollector.finalizeCurrentRow(l);
        }
    }
}

