/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.parquet;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.FilteredColumnarBatch;
import io.delta.kernel.defaults.internal.parquet.ParquetColumnWriters;
import io.delta.kernel.defaults.internal.parquet.ParquetSchemaUtils;
import io.delta.kernel.defaults.internal.parquet.ParquetStatsReader;
import io.delta.kernel.expressions.Column;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.DataFileStatistics;
import io.delta.kernel.utils.DataFileStatus;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;

public class ParquetFileWriter {
    public static final String TARGET_FILE_SIZE_CONF = "delta.kernel.default.parquet.writer.targetMaxFileSize";
    public static final long DEFAULT_TARGET_FILE_SIZE = 0x8000000L;
    private final Configuration configuration;
    private final boolean writeAsSingleFile;
    private final Path location;
    private final long targetMaxFileSize;
    private final List<Column> statsColumns;
    private long currentFileNumber;

    public ParquetFileWriter(Configuration configuration, Path path, List<Column> list) {
        this.configuration = Objects.requireNonNull(configuration, "configuration is null");
        this.location = Objects.requireNonNull(path, "directory is null");
        this.targetMaxFileSize = configuration.getLong(TARGET_FILE_SIZE_CONF, 0x8000000L);
        Preconditions.checkArgument((this.targetMaxFileSize > 0L ? 1 : 0) != 0, (String)"Invalid target Parquet file size: %s", (Object[])new Object[]{this.targetMaxFileSize});
        this.statsColumns = Objects.requireNonNull(list, "statsColumns is null");
        this.writeAsSingleFile = false;
    }

    public ParquetFileWriter(Configuration configuration, Path path) {
        this.configuration = Objects.requireNonNull(configuration, "configuration is null");
        this.writeAsSingleFile = true;
        this.location = Objects.requireNonNull(path, "destPath is null");
        this.targetMaxFileSize = Long.MAX_VALUE;
        this.statsColumns = Collections.emptyList();
    }

    public CloseableIterator<DataFileStatus> write(final CloseableIterator<FilteredColumnarBatch> closeableIterator) {
        return new CloseableIterator<DataFileStatus>(){
            private Optional<DataFileStatus> lastWrittenFileOutput = Optional.empty();
            private FilteredColumnarBatch currentBatch = null;
            private int currentBatchCursor = 0;
            private BatchWriteSupport batchWriteSupport = null;
            private StructType dataSchema = null;

            public void close() {
                Utils.closeCloseables((AutoCloseable[])new AutoCloseable[]{closeableIterator});
            }

            public boolean hasNext() {
                if (this.lastWrittenFileOutput.isPresent()) {
                    return true;
                }
                this.lastWrittenFileOutput = this.writeNextFile();
                return this.lastWrittenFileOutput.isPresent();
            }

            public DataFileStatus next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                DataFileStatus dataFileStatus = this.lastWrittenFileOutput.get();
                this.lastWrittenFileOutput = Optional.empty();
                return dataFileStatus;
            }

            private Optional<DataFileStatus> writeNextFile() {
                if (!this.hasNextRow()) {
                    return Optional.empty();
                }
                Path path = ParquetFileWriter.this.generateNextFilePath();
                assert (this.batchWriteSupport != null) : "batchWriteSupport is not initialized";
                long l = 0L;
                try (ParquetWriter parquetWriter = ParquetFileWriter.this.createWriter(path, (WriteSupport<Integer>)this.batchWriteSupport);){
                    boolean bl;
                    do {
                        if (this.consumeNextRow((ParquetWriter<Integer>)parquetWriter)) {
                            ++l;
                        }
                        boolean bl2 = bl = !ParquetFileWriter.this.writeAsSingleFile && parquetWriter.getDataSize() >= ParquetFileWriter.this.targetMaxFileSize;
                    } while (!bl && this.hasNextRow());
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException("Failed to write the Parquet file: " + path, iOException);
                }
                return Optional.of(ParquetFileWriter.this.constructDataFileStatus(path.toString(), this.dataSchema, l));
            }

            boolean hasNextRow() {
                boolean bl;
                boolean bl2 = bl = this.currentBatch != null && this.currentBatchCursor < this.currentBatch.getData().getSize();
                if (bl) {
                    return true;
                }
                do {
                    if (!closeableIterator.hasNext()) {
                        return false;
                    }
                    this.currentBatch = (FilteredColumnarBatch)closeableIterator.next();
                    this.currentBatchCursor = 0;
                } while (this.currentBatch.getData().getSize() == 0);
                ColumnarBatch columnarBatch = this.currentBatch.getData();
                this.dataSchema = columnarBatch.getSchema();
                BatchWriteSupport batchWriteSupport = this.createOrGetWriteSupport(this.dataSchema);
                ParquetColumnWriters.ColumnWriter[] columnWriterArray = ParquetColumnWriters.createColumnVectorWriters(columnarBatch);
                batchWriteSupport.setColumnVectorWriters(columnWriterArray);
                return true;
            }

            boolean consumeNextRow(ParquetWriter<Integer> parquetWriter) throws IOException {
                boolean bl;
                Optional optional = this.currentBatch.getSelectionVector();
                boolean bl2 = bl = !optional.isPresent() || !((ColumnVector)optional.get()).isNullAt(this.currentBatchCursor) && ((ColumnVector)optional.get()).getBoolean(this.currentBatchCursor);
                if (bl) {
                    parquetWriter.write((Object)this.currentBatchCursor);
                }
                ++this.currentBatchCursor;
                return bl;
            }

            BatchWriteSupport createOrGetWriteSupport(StructType structType) {
                if (this.batchWriteSupport == null) {
                    MessageType messageType = ParquetSchemaUtils.toParquetSchema(structType);
                    this.batchWriteSupport = new BatchWriteSupport(structType, messageType);
                    return this.batchWriteSupport;
                }
                if (!this.batchWriteSupport.inputSchema.equals((Object)structType)) {
                    throw new IllegalArgumentException("Input data has columnar batches with different schemas:\n schema 1: " + this.batchWriteSupport.inputSchema + "\n schema 2: " + structType);
                }
                return this.batchWriteSupport;
            }
        };
    }

    private Path generateNextFilePath() {
        if (this.writeAsSingleFile) {
            Preconditions.checkArgument((this.currentFileNumber++ == 0L ? 1 : 0) != 0, (String)"expected to write just one file");
            return this.location;
        }
        String string = String.format("%s-%03d.parquet", UUID.randomUUID(), this.currentFileNumber++);
        return new Path(this.location, string);
    }

    private ParquetWriter<Integer> createWriter(Path path, WriteSupport<Integer> writeSupport) throws IOException {
        return ((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)new ParquetRowDataBuilder(path, writeSupport).withCompressionCodec(CompressionCodecName.fromConf((String)this.configuration.get("parquet.compression", CompressionCodecName.SNAPPY.name())))).withRowGroupSize(ParquetOutputFormat.getLongBlockSize((Configuration)this.configuration))).withPageSize(ParquetOutputFormat.getPageSize((Configuration)this.configuration))).withDictionaryPageSize(ParquetOutputFormat.getDictionaryPageSize((Configuration)this.configuration))).withMaxPaddingSize(this.configuration.getInt("parquet.writer.max-padding", 0x800000))).withDictionaryEncoding(ParquetOutputFormat.getEnableDictionary((Configuration)this.configuration))).withValidation(ParquetOutputFormat.getValidation((Configuration)this.configuration))).withWriterVersion(ParquetOutputFormat.getWriterVersion((Configuration)this.configuration))).withConf(this.configuration)).build();
    }

    private DataFileStatus constructDataFileStatus(String string, StructType structType, long l) {
        try {
            Path path = new Path(string);
            FileStatus fileStatus = path.getFileSystem(this.configuration).getFileStatus(path);
            Path path2 = fileStatus.getPath();
            DataFileStatistics dataFileStatistics = this.statsColumns.isEmpty() ? new DataFileStatistics(l, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap()) : ParquetStatsReader.readDataFileStatistics(path2, this.configuration, structType, this.statsColumns);
            return new DataFileStatus(path2.toString(), fileStatus.getLen(), fileStatus.getModificationTime(), Optional.ofNullable(dataFileStatistics));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Failed to read the stats for: " + string, iOException);
        }
    }

    private static class ParquetRowDataBuilder
    extends ParquetWriter.Builder<Integer, ParquetRowDataBuilder> {
        private final WriteSupport<Integer> writeSupport;

        protected ParquetRowDataBuilder(Path path, WriteSupport<Integer> writeSupport) {
            super(path);
            this.writeSupport = Objects.requireNonNull(writeSupport, "writeSupport is null");
        }

        protected ParquetRowDataBuilder self() {
            return this;
        }

        protected WriteSupport<Integer> getWriteSupport(Configuration configuration) {
            return this.writeSupport;
        }
    }

    private static class BatchWriteSupport
    extends WriteSupport<Integer> {
        final StructType inputSchema;
        final MessageType parquetSchema;
        private ParquetColumnWriters.ColumnWriter[] columnWriters;
        private RecordConsumer recordConsumer;

        BatchWriteSupport(StructType structType, MessageType messageType) {
            this.inputSchema = Objects.requireNonNull(structType, "inputSchema is null");
            this.parquetSchema = Objects.requireNonNull(messageType, "parquetSchema is null");
        }

        void setColumnVectorWriters(ParquetColumnWriters.ColumnWriter[] columnWriterArray) {
            this.columnWriters = Objects.requireNonNull(columnWriterArray, "columnVectorWriters is null");
        }

        public String getName() {
            return "delta-kernel-default-parquet-writer";
        }

        public WriteSupport.WriteContext init(Configuration configuration) {
            Map<String, String> map = Collections.singletonMap("io.delta.kernel.default-parquet-writer", "Kernel-Defaults-3.3.2");
            return new WriteSupport.WriteContext(this.parquetSchema, map);
        }

        public void prepareForWrite(RecordConsumer recordConsumer) {
            this.recordConsumer = recordConsumer;
        }

        public void write(Integer n) {
            assert (this.recordConsumer != null) : "Parquet record consumer is null";
            assert (this.columnWriters != null) : "Column writers are not set";
            this.recordConsumer.startMessage();
            for (int i = 0; i < this.columnWriters.length; ++i) {
                this.columnWriters[i].writeRowValue(this.recordConsumer, n);
            }
            this.recordConsumer.endMessage();
        }
    }
}

