/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.engine;

import io.delta.kernel.defaults.engine.DefaultExpressionHandler;
import io.delta.kernel.defaults.engine.DefaultFileSystemClient;
import io.delta.kernel.defaults.engine.DefaultJsonHandler;
import io.delta.kernel.defaults.engine.DefaultParquetHandler;
import io.delta.kernel.defaults.engine.LoggingMetricsReporter;
import io.delta.kernel.defaults.engine.fileio.FileIO;
import io.delta.kernel.defaults.engine.hadoopio.HadoopFileIO;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.engine.ExpressionHandler;
import io.delta.kernel.engine.FileSystemClient;
import io.delta.kernel.engine.JsonHandler;
import io.delta.kernel.engine.MetricsReporter;
import io.delta.kernel.engine.ParquetHandler;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;

public class DefaultEngine
implements Engine {
    private final FileIO fileIO;

    protected DefaultEngine(FileIO fileIO) {
        this.fileIO = fileIO;
    }

    public ExpressionHandler getExpressionHandler() {
        return new DefaultExpressionHandler();
    }

    public JsonHandler getJsonHandler() {
        return new DefaultJsonHandler(this.fileIO);
    }

    public FileSystemClient getFileSystemClient() {
        return new DefaultFileSystemClient(this.fileIO);
    }

    public ParquetHandler getParquetHandler() {
        return new DefaultParquetHandler(this.fileIO);
    }

    public List<MetricsReporter> getMetricsReporters() {
        return Collections.singletonList(new LoggingMetricsReporter());
    }

    public static DefaultEngine create(Configuration configuration) {
        return new DefaultEngine(new HadoopFileIO(configuration));
    }

    public static DefaultEngine create(FileIO fileIO) {
        return new DefaultEngine(fileIO);
    }
}

